package org.postgresforest.tool.cli.action;

import java.util.ArrayList;

import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.BrokenLog;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

/**
 * グローバルシステムカタログのログへのコマンドラインツール用のアクションを提供するクラス
 */
public class BrokenLogActions {

	private static final String[] SHOW_BROKEN_LOG_HEADER = {"SERVERID","DATETIME","CLIENT","MSG","STATUS","QUERY " }; //$NON-NLS-1$

	/**
	 * ログの表示
	 * @param gsc GSCヘの接続情報
	 */	
	public static void show(GSCdata gsc) {

		
		//ログ情報取得
		BrokenLog[] brokenLogs;
		try {
			brokenLogs  = gsc.getBrokenLogs();
		} catch (Exception e) {
			Logger.error(MessagesCommandLine.getString("cui.error.brokenlog.show"));
			Logger.error(e.getMessage());
			Logger.trace(e);
			return;
		}
		
			
		//ログ情報表示
		Logger.println(MessagesCommandLine.getString("cui.message.brokenlog.show")) ;

		Table2StringUtil table2StringUtil = new Table2StringUtil( SHOW_BROKEN_LOG_HEADER );
		if( brokenLogs != null ){
			for (int i = 0; i < brokenLogs.length; i++) {
				BrokenLog brokenLog = brokenLogs[i];
	
				ArrayList row = new ArrayList();
	
				row.add(new Integer(brokenLog.getServerId()) ); //$NON-NLS-1$
				row.add(brokenLog.getTimestamp()); //$NON-NLS-1$
				row.add(brokenLog.getClient() ); //$NON-NLS-1$
				row.add(brokenLog.getMessage() ); //$NON-NLS-1$
				row.add(brokenLog.getState() ); //$NON-NLS-1$
				row.add(brokenLog.getQuery());
	
				
				table2StringUtil.addRow(row);
				
			}
		}

		table2StringUtil.print();

	}

	/**
	 * ログのクリア
	 * @param gsc GSCヘの接続情報
	 */	
	public static void clear(GSCdata gsc) {

		try {
			gsc.clearBrokenLogs();
		} catch (Exception e) {
			Logger.error(MessagesCommandLine.getString("cui.error.brokenlog.clear"));
			Logger.error(e.getMessage());
			Logger.trace(e);

			return;
		}
		
		Logger.println(MessagesCommandLine.getString("cui.message.brokenlog.clear"));

		
	}
}
