package org.postgresforest.tool.tests;

import java.io.*;
import java.sql.*;
import junit.framework.*;

import org.postgresforest.tool.lib.Config;
import org.postgresforest.tool.lib.Database;
import org.postgresforest.tool.lib.Instance;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.lib.ForestToolException;

/*
 * 試験内容
 *  - インスタンス登録
 *  - インスタンス一覧取得
 *  - インスタンス取得
 *  - インスタンス削除
 */
public class TestGSCdata2 extends ForestToolTestCase {
	String user = "snaga";
	String pass = "";

	public void setUp()
	{
	}

	public void tearDown()
	{
	}

	/*
	 * インスタンス登録（正常系）
	 */
	public void testRegisterInstance001()
	{
		GSCdata gsc = null;

		initializeGSC();

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
			assertTrue(gsc!=null);

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			ins = gsc.registerInstance("localhost", "9999");
			assertTrue( ins!=null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==2 );

			/*
			 * インスタンス取得・確認
			 */
			ins = gsc.getInstance(ii[0]);
			assertTrue( ins.getHostName().equals("localhost") );
			assertTrue( ins.getPortNumber().equals("9998") );

			ins = gsc.getInstance(ii[1]);
			assertTrue( ins.getHostName().equals("localhost") );
			assertTrue( ins.getPortNumber().equals("9999") );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス登録（nullチェック）
	 */
	public void testRegisterInstance002()
	{
		GSCdata gsc = null;

		initializeGSC();

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
			assertTrue(gsc!=null);

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			ins = gsc.registerInstance(null, "9999");
			assertTrue( ins==null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス登録（nullチェック）
	 */
	public void testRegisterInstance003()
	{
		GSCdata gsc = null;

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
			assertTrue(gsc!=null);

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			ins = gsc.registerInstance("localhost", null);
			assertTrue( ins==null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス登録（nullチェック）
	 */
	public void testRegisterInstance004()
	{
		GSCdata gsc = null;

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
			assertTrue(gsc!=null);

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			ins = gsc.registerInstance(null, null);
			assertTrue( ins==null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス取得（異常系/ID範囲外）
	 */
	public void testGetInstance001()
	{
		GSCdata gsc = null;

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);
			assertTrue(gsc!=null);

			ins = gsc.getInstance(100);
			assertTrue(ins==null);

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス削除（正常系/Instanceで削除）
	 */
	public void testUnregisterInstance001()
	{
		GSCdata gsc = null;

		initializeGSC();

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);

			ins = gsc.registerInstance("localhost", "9999");

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==2 );

			/*
			 * インスタンス取得・確認
			 */
			ins = gsc.getInstance(ii[1]);

			/*
			 * インスタンス削除
			 */
			assertTrue( gsc.unregisterInstance(ins) );

			/*
			 * 削除確認
			 */
			ins = gsc.getInstance(ii[1]);   // 直前のIDで確認
			assertTrue( ins==null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス削除（正常系/IDで削除）
	 */
	public void testUnregisterInstance002()
	{
		GSCdata gsc = null;

		initializeGSC();

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);

			ins = gsc.registerInstance("localhost", "9999");

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==2 );

			/*
			 * インスタンス取得・確認
			 */
			ins = gsc.getInstance(ii[1]);

			/*
			 * インスタンス削除
			 */
			assertTrue( gsc.unregisterInstance(1) );

			/*
			 * 削除確認
			 */
			ins = gsc.getInstance(ii[1]);   // 直前のIDで確認
			assertTrue( ins==null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==1 );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}

	/*
	 * インスタンス削除（異常系 nullチェック/範囲外）
	 */
	public void testUnregisterInstance003()
	{
		GSCdata gsc = null;

		initializeGSC();

		try {
			int[] ii = null;
			Instance ins = null;

			gsc = new GSCdata("localhost", "9998", "gsctest",
							  user, pass);

			ins = gsc.registerInstance("localhost", "9999");

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==2 );

			/*
			 * インスタンス取得・確認
			 */
			ins = gsc.getInstance(ii[1]);

			/*
			 * インスタンス削除/null
			 */
			assertTrue( gsc.unregisterInstance(null)==false );

			/*
			 * 削除されていないことを確認
			 */
			ins = gsc.getInstance(ii[1]);   // 直前のIDで確認
			assertTrue( ins!=null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==2 );

			/*
			 * インスタンス削除/範囲外
			 */
			assertTrue( gsc.unregisterInstance(2)==false );

			/*
			 * 削除されていないことを確認
			 */
			ins = gsc.getInstance(ii[1]);   // 直前のIDで確認
			assertTrue( ins!=null );

			ii = gsc.getInstanceIds();
			assertTrue( ii.length==2 );

			gsc.close();
		}
		catch (ForestToolException e)
		{
			System.out.println(e.getMessage());
			fail();
		}
	}


	public static void main(String[] args)
	{
		junit.textui.TestRunner.run(TestGSCdata2.class);
	}
}
