#!/bin/sh

. ./common/test_init_gsc.sh | tee result

. ./common/dropdb.sh testdb

./run_tool.sh<<EOF
show instance;
create instance ${HOST_1} ${PORT_1};
show instance;
create instance ${HOST_2} ${PORT_2};
show instance;
create instance ${HOST_3} ${PORT_3};
show instance;

check gsc;

show db;
create db testdb(0,2,1,3) with "encoding='utf-8'";
show db;

open db testdb;
create table t1 ( uid integer primary key, name text not null );
alter table t1 add constraint t1_name_check check (name!=null );
show table;
create index t1_name_idx on t1(name);
alter index t1_name_idx rename to t1_;
part table t1 (uid) 2;
show table t1;
create index t1_name_idx on t1(uid);
alter index t1_name_idx rename to t2_;
close db;
EOF
