#!/bin/sh

./run_tool.sh<<EOF
open db salesdemo;
CREATE TABLE item (
    item_cd character(10) NOT NULL,
    item_name character varying(30),
    unit_mony integer,
    unit_name character(4),
    stock_num integer,
    PRIMARY KEY (item_cd)
);

CREATE TABLE customer (
    cust_cd character(10) NOT NULL,
    cust_name character varying(30),
    post_no character(10),
    address character varying(50),
    phone_no character(20),
    pres_name character varying(20),
    PRIMARY KEY (cust_cd)
);

CREATE TABLE employee (
    emp_cd character(10) NOT NULL,
    distcent_cd character(10),
    name character varying(10),
    "password" character varying(20),
    dept_name character varying(30),
    PRIMARY KEY (emp_cd)
);

CREATE TABLE salesorder (
    order_no character(18) NOT NULL,
    cust_cd character(10),
    emp_cd character(10),
    distcent_cd character(10),
    ent_date date,
    ent_time time without time zone,
    supp_date date,
    sum integer,
    order_stat smallint,
    PRIMARY KEY (order_no)
);

CREATE TABLE salesordertail (
    order_no character(18) NOT NULL,
    item_cd character(10) NOT NULL,
    pack_num integer,
    sepa_num integer,
    sum integer,
    PRIMARY KEY (order_no, item_cd)
);
close db ;
EOF
