/*-------------------------------------------------------------------------
*
* Copyright (c) 2003-2005, PostgreSQL Global Development Group
*
* IDENTIFICATION
*   $PostgreSQL: pgjdbc/org/postgresforest/fastpath/FastpathArg.java,v 1.12 2005/01/11 08:25:45 jurka Exp $
*
*-------------------------------------------------------------------------
*/
package org.postgresforest.fastpath;

import java.sql.SQLException;
import org.postgresforest.core.ParameterList;

// Not a very clean mapping to the new QueryExecutor/ParameterList
// stuff, but it seems hard to support both v2 and v3 cleanly with
// the same model while retaining API compatibility. So I've just
// done it the ugly way..

/**
 *     Each fastpath call requires an array of arguments, the number and type
 *     dependent on the function being called.
 */
public class FastpathArg
{
    /**
     * Encoded byte value of argument.
     */
    private final byte[] bytes;
    private final int bytesStart;
    private final int bytesLength;

    /**
     * Constructs an argument that consists of an integer value
     * @param value int value to set
     */
    public FastpathArg(int value)
    {
        bytes = new byte[4];
        bytes[3] = (byte) (value);
        bytes[2] = (byte) (value >> 8);
        bytes[1] = (byte) (value >> 16);
        bytes[0] = (byte) (value >> 24);
        bytesStart = 0;
        bytesLength = 4;
    }

    /**
     * Constructs an argument that consists of an array of bytes
     * @param bytes array to store
     */
    public FastpathArg(byte bytes[])
    {
        this(bytes, 0, bytes.length);
    }

    /**
     * Constructs an argument that consists of part of a byte array
     * @param buf source array
     * @param off offset within array
     * @param len length of data to include
     */
    public FastpathArg(byte buf[], int off, int len)
    {
        this.bytes = buf;
        this.bytesStart = off;
        this.bytesLength = len;
    }

    /**
     * Constructs an argument that consists of a String.
     * @param s String to store
     */
    public FastpathArg(String s)
    {
        this(s.getBytes());
    }

    void populateParameter(ParameterList params, int index) throws SQLException {
        if (bytes == null)
            params.setNull(index, 0);
        else
            params.setBytea(index, bytes, bytesStart, bytesLength);
    }
}

