/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm;

/**
 * SQL実行スレッド同期処理管理クラス.
 * 複数のスレッド（オブジェクト）の同期をとる。
 *
 * @since 1.1
 */
public class Lock {
	protected int m_count = 0;
	protected int m_waitedCount = 0;

	/**
	 * コンストラクタ 
	 * @param count 同期オブジェクト数
	 */
	public Lock(int count){
		reset(count);
	}
	
	/**
	 * 同期オブジェクト設定
	 * @param count 同期オブジェクト数
	 * @since 2.1
	 */
	public void reset(int count) {
		this.m_count = count;
		this.m_waitedCount = count;
	}
	/**
	 * すべてのSubThreadの実行終了を待機
	 * @throws InterruptedException
	 */
	public synchronized void waitAllEnd() throws InterruptedException{
		boolean flg = true; 
		while(flg){	
			if(m_count > 0){
				this.wait();
			}else{
				flg = false;
			}
		}
	}
	
	/**
	 * どれかひとつSubThreadの実行終了を待機
	 * @throws InterruptedException
	 */
	public synchronized void waitEnd() throws InterruptedException{
		if(m_count > 0 && 
		   m_count == m_waitedCount){
			this.wait();
		}
		m_waitedCount = m_count;
	}

	/**
	 * SubThreadの実行終了をカウント。
	 *
	 */
	public synchronized void notifyEnd(){

		m_count--;

		this.notifyAll();
	}

}
