/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm;

/**
 * ソート用Nullの代理オブジェクト
 * @since 2.0
 */
public class NullKey implements Comparable {


	/* (非 Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		if(this.equals(o)){
			return 0;
		}
		// PostgresSQLではNULLは昇順で後ろに来るので常に正の数を返す
		return 1;
	}


	/* (非 Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		//インスタンスの比較ではなく、クラス名で比較する。
		if (obj instanceof NullKey) {
			return true;	
		}
		return false;	
	}

}
