package org.postgresforest.vm.core;

import java.sql.SQLException;
import java.util.Properties;

import org.postgresforest.Driver;
import org.postgresforest.core.ConnectionFactory;
import org.postgresforest.core.ProtocolConnection;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.StatementThreadMng;
import org.postgresforest.vm.gsc.GscData;

public class ConnectionFactoryImpl extends ConnectionFactory {

	public ProtocolConnection openConnectionImpl(String host, int port,
			String user, String database, Properties info) throws SQLException {

//		System.out.println(host);
//		System.out.println(port);
//		System.out.println(user);
//		System.out.println(database);
//		System.out.println(info);

		//GSCがセットされていなければ、通常の接続とみなして、nullを返す。
		String strGSC = info.getProperty("GSC");
		if(strGSC == null){
			
			return null;
			
		}
		info.remove("GSC");

		String strConfig = info.getProperty("CONFIG");

		// DB名
		String strDBname = info.getProperty("PGDBNAME");

		// Ver2.1 ログ出力
		LogUtil logUtil = new LogUtil();

		// グローバルシステムカタログのインスタンス生成し、コネクションに格納
		GscData gsc = new GscData(strGSC, strConfig, strDBname, info, logUtil );

//		if (Driver.logDebug)
//		 logUtil.debug("connect " + url);

		//Ver1.1 スレッドプーリング
		 //サーバ数分スレッドプーリング Vew2.0 + 1
		StatementThreadMng threadMng = new StatementThreadMng(gsc.getServerCount()+1);
		 //Ver2.1
		if (Driver.logDebug || Driver.logInfo)
			threadMng.setLogUtil(logUtil);
		 

		 ProtocolConnectionImpl protocolConnectionImpl = new ProtocolConnectionImpl(database,gsc,threadMng,user);
		 
		 
		return protocolConnectionImpl;

	}

}
