/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.vm.err;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.SQLException;

import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;

/**
 *
 * ForestPSQLException
 * 
 * すべてのサーバでエラーが発生した場合にエラーがセットされる例外クラス
 * メッセージに、NextExceptionにセットされる例外のメッセージを連結します。
 * 接続先と、クエリーが指定される場合は、これらの情報もメッセージに連結されます。
 * また、printStackTraceはNextExceptionに設定された例外のstackTraceを順次出力します。
 * 
 * @version $Revision: 1.1.2.1 $
 * @since 3.1 
 */
public class ForestPSQLException extends PSQLException {

    StringBuffer m_additionalMessage;
    
    /**
     * @param msg
     * @param state
     */
    public ForestPSQLException(String msg, PSQLState state) {
        super(msg, state);
        m_additionalMessage = new StringBuffer("\n");
    }


    /* (非 Javadoc)
     * @see java.lang.Throwable#getLocalizedMessage()
     */
    public String getLocalizedMessage() {
        //NextExceptionのメッセージを連結
        if(m_additionalMessage != null)
            return m_additionalMessage.insert(0, super.getLocalizedMessage()).toString();
        else
            return super.getLocalizedMessage();
    }
    /* (非 Javadoc)
     * @see java.lang.Throwable#getMessage()
     */
    public String getMessage() {
        //NextExceptionのメッセージを連結
        if(m_additionalMessage != null)
            return m_additionalMessage.insert(0, super.getMessage()).toString();
        else
            return super.getMessage();
    }
    /**
     * 
     * @param ex nextExceptionにセットされる例外
     * @param url 例外が発生した接続先
     * @param sql 例外が発生した接続先クエリー
     */
    public synchronized void setNextException(SQLException ex, String url, String sql) {
        //連結用メッセージをセット
        m_additionalMessage.append("CONNECTION:");
        m_additionalMessage.append(url);
        m_additionalMessage.append("\nQUERY:");
        m_additionalMessage.append(sql);
        m_additionalMessage.append("\n");
        setNextException(ex);
    }
    /* (非 Javadoc)
     * @see java.sql.SQLException#setNextException(java.sql.SQLException)
     */
    public synchronized void setNextException(SQLException ex) {
        //連結用メッセージをセット
        m_additionalMessage.append(ex.getMessage());
        m_additionalMessage.append("\n");
        super.setNextException(ex);
    }


    /* (非 Javadoc)
     * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
     */
    public void printStackTrace(PrintStream s) {
        //自分のスタックトレースを出力
        super.printStackTrace(s);
		s.println();
		s.println();

        //NextExceptionのスタックトレースを出力
		SQLException e = this;
        while(true){
			e = e.getNextException();
			if(e == null)
				break;
			e.printStackTrace(s);
			s.println();
			s.println();
		}

    }
    /* (非 Javadoc)
     * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
     */
    public void printStackTrace(PrintWriter s) {
        //自分のスタックトレースを出力
        super.printStackTrace(s);
		s.println();
		s.println();

        //NextExceptionのスタックトレースを出力
		SQLException e = this;
        while(true){
			e = e.getNextException();
			if(e == null)
				break;
			e.printStackTrace(s);
			s.println();
			s.println();
		}

    
    }
}
