/*-------------------------------------------------------------------------
*
* Copyright (c) 2004-2005, PostgreSQL Global Development Group
*
* IDENTIFICATION
*   $PostgreSQL: pgjdbc/org.postgresforest.jdbc3g/ForestDatabaseMetaData.java,v 1.4 2005/01/11 08:25:47 jurka Exp $
*
*-------------------------------------------------------------------------
*/
package org.postgresforest.vm.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;


public class ForestDatabaseMetaData extends org.postgresforest.jdbc3.AbstractJdbc3DatabaseMetaData implements java.sql.DatabaseMetaData
{
	ForestConnection m_con;
	

	public ForestDatabaseMetaData(ForestConnection conn)
    {
        super(conn);
		m_con = (ForestConnection) connection;
    }



	public ResultSet getCatalogs() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getCatalogs();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getColumnPrivileges(String catalog, String schema,
			String table, String columnNamePattern) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getColumnPrivileges(catalog, schema, table,
					columnNamePattern);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getColumns(String catalog, String schemaPattern,
			String tableNamePattern, String columnNamePattern)
			throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getColumns(catalog, schemaPattern, tableNamePattern,
					columnNamePattern);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getCrossReference(String primaryCatalog,
			String primarySchema, String primaryTable, String foreignCatalog,
			String foreignSchema, String foreignTable) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getCrossReference(primaryCatalog, primarySchema,
					primaryTable, foreignCatalog, foreignSchema, foreignTable);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getExportedKeys(String catalog, String schema, String table)
			throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getExportedKeys(catalog, schema, table);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getImportedKeys(String catalog, String schema, String table)
			throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getImportedKeys(catalog, schema, table);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getIndexInfo(String catalog, String schema,
			String tableName, boolean unique, boolean approximate)
			throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getIndexInfo(catalog, schema, tableName, unique,
					approximate);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxCatalogNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxCatalogNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxColumnNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxColumnNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxColumnsInIndex() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxColumnsInIndex();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxCursorNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxCursorNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxProcedureNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxProcedureNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxSchemaNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxSchemaNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxTableNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxTableNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public int getMaxUserNameLength() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getMaxUserNameLength();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getPrimaryKeys(String catalog, String schema, String table)
			throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getPrimaryKeys(catalog, schema, table);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getProcedureColumns(String catalog, String schemaPattern,
			String procedureNamePattern, String columnNamePattern)
			throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getProcedureColumns(catalog, schemaPattern,
					procedureNamePattern, columnNamePattern);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getProcedures(String catalog, String schemaPattern,
			String procedureNamePattern) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getProcedures(catalog, schemaPattern,
					procedureNamePattern);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getSchemas() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getSchemas();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getTablePrivileges(String catalog, String schemaPattern,
			String tableNamePattern) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getTablePrivileges(catalog, schemaPattern,
					tableNamePattern);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getTables(String catalog, String schemaPattern,
			String tableNamePattern, String[] types) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getTables(catalog, schemaPattern, tableNamePattern,
					types);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getTableTypes() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getTableTypes();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getTypeInfo() throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getTypeInfo();
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getUDTs(String catalog, String schemaPattern,
			String typeNamePattern, int[] types) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super
					.getUDTs(catalog, schemaPattern, typeNamePattern, types);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getVersionColumns(String catalog, String schema,
			String table) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getVersionColumns(catalog, schema, table);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

	public ResultSet getBestRowIdentifier(String catalog, String schema,
			String table, int scope, boolean nullable) throws SQLException {
		try {
			m_con.setMetaDataAccess();
			return super.getBestRowIdentifier(catalog, schema, table, scope,
					nullable);
		} finally {
			m_con.clearMetaDataAccess();
		}
	}

}
