/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest;

import java.sql.*;
import java.util.List;
import java.util.concurrent.Callable;

import org.postgresforest.apibase.*;
import org.postgresforest.constant.ErrorStr;
import org.postgresforest.exception.ForestResourceDisposedException;

public final class ForestResultSetMetaData implements ResultSetMetaData {
    
    private final EntrypointCommonResource epCommonResource;
    private final List<ResultSetMetaData> resMetaList;
    private final int execServerId;
    
    public ForestResultSetMetaData(final EntrypointCommonResource epCommonResource, final List<ResultSetMetaData> resMetaList, final int execServerId) {
        this.epCommonResource = epCommonResource;
        this.execServerId = execServerId;
        this.resMetaList = resMetaList;
    }
    
    private boolean isClosed = false;
    private void checkClosed() throws ForestResourceDisposedException {
        if (isClosed == true) {
            throw new ForestResourceDisposedException(ErrorStr.RESOURCE_CLOSED.toString());
        }
    }
    
    public String getCatalogName(int arg0) throws SQLException {
        checkClosed();
        final Callable<String> task = new ResultSetMetaDataTask.GetCatalogName(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public String getColumnClassName(int arg0) throws SQLException {
        throw new SQLException(org.postgresforest.constant.ErrorStr.NOT_SUPPORTED.toString());
    }
    
    public int getColumnCount() throws SQLException {
        checkClosed();
        final Callable<Integer> task = new ResultSetMetaDataTask.GetColumnCount(resMetaList.get(execServerId));
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public int getColumnDisplaySize(int arg0) throws SQLException {
        checkClosed();
        final Callable<Integer> task = new ResultSetMetaDataTask.GetColumnDisplaySize(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public String getColumnLabel(int arg0) throws SQLException {
        checkClosed();
        final Callable<String> task = new ResultSetMetaDataTask.GetColumnLabel(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public String getColumnName(int arg0) throws SQLException {
        checkClosed();
        final Callable<String> task = new ResultSetMetaDataTask.GetColumnName(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public int getColumnType(int arg0) throws SQLException {
        checkClosed();
        final Callable<Integer> task = new ResultSetMetaDataTask.GetColumnType(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public String getColumnTypeName(int arg0) throws SQLException {
        checkClosed();
        final Callable<String> task = new ResultSetMetaDataTask.GetColumnTypeName(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public int getPrecision(int arg0) throws SQLException {
        checkClosed();
        final Callable<Integer> task = new ResultSetMetaDataTask.GetPrecision(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public int getScale(int arg0) throws SQLException {
        checkClosed();
        final Callable<Integer> task = new ResultSetMetaDataTask.GetScale(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public String getSchemaName(int arg0) throws SQLException {
        checkClosed();
        final Callable<String> task = new ResultSetMetaDataTask.GetSchemaName(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public String getTableName(int arg0) throws SQLException {
        checkClosed();
        final Callable<String> task = new ResultSetMetaDataTask.GetTableName(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId);
    }
    
    public boolean isAutoIncrement(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsAutoIncrement(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean isCaseSensitive(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsCaseSensitive(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean isCurrency(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsCurrency(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsDefinitelyWritable(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public int isNullable(int arg0) throws SQLException {
        checkClosed();
        final Callable<Integer> task = new ResultSetMetaDataTask.IsNullable(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).intValue();
    }
    
    public boolean isReadOnly(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsReadOnly(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean isSearchable(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsSearchable(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean isSigned(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsSigned(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
    public boolean isWritable(int arg0) throws SQLException {
        checkClosed();
        final Callable<Boolean> task = new ResultSetMetaDataTask.IsWritable(resMetaList.get(execServerId), arg0);
        return epCommonResource.executeOneApi(task, execServerId).booleanValue();
    }
    
}
