/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import java.util.List;

import org.postgresforest.constant.UdbValidity;
import org.postgresforest.exception.ForestResourceDisposedException;

public interface ForestJdbcInfo {
    
    /**
     * その時点でのユーザデーターべースの整合性情報を集約し、
     * サーバIDをインデックスとしたリスト形式で返却する関数。
     * @return サーバIDをインデックスとした現在のユーザDBの状態を表すリスト
     * @throws ForestResourceDisposedException このコネクションが既に閉じられている場合
     */
    public List<UdbValidity> getValidityList() throws ForestResourceDisposedException;
    
    
    // カレントコネクション数
    // 現在の管理情報参照数
    // 管理情報インスタンスの継続時刻
}
