/* 
 * Copyright (C) since 2008 NTT DATA Corporation 
 *  
 */ 

package org.postgresforest.util;

import java.util.Properties;

import net.jcip.annotations.*;

/**
 * PostgreSQLへの接続URL・ID/PASSを保持するクラス
 */
@Immutable
public class PgUrl {
    private final String ipport;
    private final String url;
    private final String dbname;
    private final Properties prop;
    
    /**
     * PgUrlクラスのコンストラクタ<br>
     * 基本的にこのコンストラクタでは引数値のチェックは行っていない
     * @param ipport
     * @param dbname
     * @param userid
     * @param passwd
     */
    public PgUrl(final String ipport, final String dbname, final String userid, final String passwd) {
        this.ipport = ipport;
        this.dbname = dbname;
        this.url = "jdbc:postgresql://" + ipport + "/" + dbname;
        this.prop = new Properties();
        prop.setProperty("user", userid);
        prop.setProperty("password", passwd);
    }
    
//    public PgUrl(final String ipportdb, final String userid, final String passwd) {
//        final String[] elems = ipportdb.split("/");
//        if (elems.length != 2) {
//            // TO DO 例外を投げる
//        }
//        this.ipport = elems[0];
//        this.url = "jdbc:postgresql://" + ipport + "/" + elems[1];
//        this.prop = new Properties();
//        prop.setProperty("user", userid);
//        prop.setProperty("password", passwd);
//    }
    
    /** このインスタンスが保持しているIP:PORT/DB名に接続するための接続文字列を返却する */
    public String getUrl() {
        return url;
    }
    
    /** このインスタンスが保持しているIP:PORTのみの部分文字列を返却する */
    public String getIpPort() {
        return ipport;
    }
    
    /** このインスタンスが保持しているDB名のみの文字列を返却する */
    public String getDbname() {
        return dbname;
    }
    
    /**
     * 接続時に使用するユーザ名/パスワードのみを含んだpropertyを返却する<br>
     * <b>注：この関数は、管理情報DBへのアクセスは管理情報DB名と同一の
     * ユーザ名・パスワードでアクセスする際に使用していたものであり、
     * 現在の仕様（各ユーザデータベース上で最初にconnectされた際のユーザ名・
     * パスワードで管理情報にアクセスし続ける）とは異なるものとなるため
     * 使用してはならない。この関数は将来的に管理DBへのアクセスユーザ・
     * パスワードについてよりよい仕様・実現方法が出て来た場合のために
     * ノリシロとして保存されているにすぎない</b>
     * @return 
     */
    @Deprecated public Properties getProperty() {
        return prop;
    }
}
