#!/bin/sh

if [ $# -ne 7 ] ; then
    echo "Usage : ${0} [PSQL-COMMAND] [IP] [PORT] [USERNAME] [IP0:PORT0] [IP1:PORT1] [USERDB]"
    exit 1
fi

PSQL=${1}
IP=${2}
PORT=${3}
USERNAME=${4}
URL0=${5}
URL1=${6}
USRDB=${7}
MNGDB="${USRDB}_pghainfo"

${PSQL} -h ${IP} -p ${PORT} -U ${USERNAME} -d template1 <<EOF
CREATE DATABASE ${MNGDB};
\c ${MNGDB}
BEGIN;
CREATE TABLE server_info (
    serverid smallint,
    udb_url text,
    udb_validity smallint
);
ALTER TABLE server_info ADD PRIMARY KEY (serverid);
CREATE TABLE global_config (
    key text,
    value text
);
ALTER TABLE global_config ADD PRIMARY KEY (key);
CREATE TABLE local_config (
    configid text,
    key text,
    value text
);
ALTER TABLE local_config ADD PRIMARY KEY (configid, key);
CREATE TABLE broken_log_detail (
    serverid smallint,
    time timestamp,
    client text,
    api_task text,
    err_msg text,
    err_type text,
    err_state text,
    err_query text,
    err_stack text,
    app_thread text,
    app_stack text
);
CREATE VIEW broken_log as (
    SELECT
        serverid,
        time,
        client,
        api_task,
        err_msg,
        err_type,
        err_state,
        err_query
    FROM broken_log_detail
);
INSERT INTO server_info values (0, '${URL0}/${USRDB}', 1);
INSERT INTO server_info values (1, '${URL1}/${USRDB}', 1);
INSERT INTO global_config values ('mngdb_read_duration', '30');
INSERT INTO global_config values ('mngcon_create_timeout', '10');
INSERT INTO global_config values ('mngquery_exec_timeout', '10');
INSERT INTO global_config values ('mngdb_max_burst_error', '2');
INSERT INTO global_config values ('broken_error_prefix', '08,53,57P,3D');
INSERT INTO global_config values ('log_level', '2');
INSERT INTO global_config values ('log_formatter_name', 'org.postgresforest.util.ForestLogFormatter');
INSERT INTO global_config values ('log_console_enable', '1');
INSERT INTO global_config values ('log_file_enable', '0');
INSERT INTO global_config values ('log_file_name', '/var/log/forest.log.%u-%g');
INSERT INTO global_config values ('log_file_size_mb', '0');
INSERT INTO global_config values ('log_file_rotate_count', '1');
INSERT INTO local_config values ('DEFAULT', 'api_exec_timeout', '600');
INSERT INTO local_config values ('DEFAULT', 'fast_api_return_on_db_fail', '1');
COMMIT;
EOF
