<?php

/*
 * postLdapAdmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ѥ桼ɲò
 *
 * $RCSfile: admin_user_add.php,v $
 * $Revision: 1.20 $
 * $Date: 2007/08/23 06:47:43 $
 **********************************************************/

include_once("../../lib/libcommon");
include_once("../../lib/libpage");
include_once("../../lib/libsess");
include_once("../../lib/libldap");

/********************************************************
ƥڡ
*********************************************************/

/* ֤μ */
define("MY_TAB", TAB_USER);

/* ѥ󤯤ꥹ */
$topic[0]["name"] = TOPIC_USER_CONTROL;
$topic[0]["url"] = "admin_user_menu.php";
$topic[1]["name"] = TOPIC_USER_REGIST;
$topic[1]["url"] = "";

define("OPERATION", "桼ɲ");

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {

        global $web_conf;
        global $sesskey;
        global $mode;
        global $postdata;

        $hiddendata['sk'] = $sesskey;

        if ($mode == ADD_MODE) {
            $postdata['quota'] = $web_conf["diskquotadefault"];
        } elseif ($mode == POST_ADD_MODE) {
            $postdata = $_POST;
        }

        print_admin_form($mode, $postdata, $hiddendata); 

    }
};


/***********************************************************
 * check_add_data
 *
 * 桼ɲûͥå
 *
 * []
 *        &$data     ϥǡ
 * [֤]
 *        TRUE       
 *        FALSE      顼
 *
 **********************************************************/
function check_add_data(&$data)
{
    global $err_msg;
    global $domain;
    $transes = array();

    /* 桼̾Υå(ɬ) */
    if ($data["uid"] == "") {
        $err_msg = "桼̾ϤƤޤ";
        return FALSE;
    }
    if (check_name($data["uid"], MAXUID) === FALSE) {
        return FALSE;
    }

    /* ѥɤΥå(ɬ) */
    if (check_passwd($data["pass"], MINPASSWD, MAXPASSWD) === FALSE) {
        return FALSE;
    }

    /* ᡼ܥå̤Υå */
    if (check_diskquota($data["quota"]) === FALSE) {
        return FALSE;
    }

    /* ᡼륨ꥢΥå */
    if ($data["alias"] != "") {
        if ($data["alias"] == $data["uid"]) {
            $err_msg = "᡼륨ꥢ桼̾ȽʣƤޤ";
            return FALSE;
        }
        if (check_name($data["alias"], MAXNAME) === FALSE) {
            $err_msg = "᡼륨ꥢηǤ";
            return FALSE;
        }
    }

    /* ѥɡѥ(ǧ)Υå */
    if ($data["pass"] != $data["re_pass"]) {
        $err_msg = "ѥɤפޤ";
        return FALSE;
    }

    /* 桼̾νʣå */
    $mail = $data["uid"] . "@" . $domain;
    $ret = check_duplicate($mail);
    if ($ret == LDAP_FOUNDUSER) {
        $err_msg = "桼̾ϴ˻ȤƤޤ";
        return FALSE;
    } elseif ($ret == LDAP_ERRUSER) {
        return FALSE;
    }
    $data["mail"] = $mail;

    /* ᡼žɥ쥹Υå */
    if ($data["trans"] != "") {
        if (check_mail ($data["trans"]) === FALSE) {
            $err_msg = "᡼žɥ쥹ηǤ";
            return FALSE;
        }
        /* ᡼¸å */
        if (!isset($data["save"])) {
            $err_msg = "᡼Ĥ/Ĥʤ꤬Ƥޤ";
            return FALSE;
        } elseif (check_flg($data["save"]) === FALSE) {
            $err_msg = "᡼Ĥ/ĤʤͤǤ";
            return FALSE;
        }
    }

    /* ᡼륨ꥢνʣå */
    if ($data["alias"] != "") {
        $data["mailalias"] = $data["alias"] . "@" . $domain;
        $ret = check_duplicate($data["mailalias"]);
        if ($ret == LDAP_FOUNDUSER) {
            $err_msg = "᡼륨ꥢϴ˻ȤƤޤ";
            return FALSE;
        } elseif ($ret == LDAP_ERRUSER) {
            return FALSE;
        }
    }


    /* ᡼žɥ쥹Υå */
    if ($data['trans'] != "") {
        if ($data['trans'] == $mail) {
            $err_msg = "᡼žɥ쥹᡼륢ɥ쥹ȽʣƤޤ";
            return FALSE;
        }
        if (isset($data["mailalias"]) && $data['trans'] == $data["mailalias"]) {
            $err_msg = "᡼žɥ쥹᡼륨ꥢȽʣƤޤ";
            return FALSE;
        }
        if (isset ($data["save"]) && $data["save"] == ON) {
            /* ᡼Ĥξžɥ쥹˼᡼륢ɥ쥹ɲ */
            array_push($transes, $mail);
        }
        if ($data["trans"] != "") {
            array_push($transes, $data["trans"]);
        }

        $data["transes"] = $transes;
    }
    return TRUE;
}

/***********************************************************
 * add_user
 *
 * 桼ǡɲä
 *
 * []
 *       $data    ɲå桼ΥǡǼ줿Ϣ
 *
 * [֤]
 *       TRUE     
 *       FALSE    顼
 *
 **********************************************************/
function add_user($data)
{
    global $web_conf;
    global $err_msg;
    global $domain;
    global $attr;

    /* Ͽѥǡ */
    $user = $data["uid"];
    $pass = CRYPT . my_crypt($data["pass"]);
    $mail = $data["mail"];
    $alias = $data["alias"];
    $maildir = $web_conf["basemaildir"] . "/" . $user . "/";
    $objectclass = mk_oc_list($web_conf['ldapobjectclass']);

    /* LDAPϿɬ°Υå */
    $attr = array("objectClass" => $objectclass,
                  "uid" => $data["uid"],
                  "userPassword" => $pass,
                  "mail" => $mail,
                  "mailDirectory" => $maildir);

    /* ɬܤǤϤʤ°Υå */
    if ($data["quota"] != "") {
        $quota = $data["quota"] * 1024 * 1024;
        $attr["quotaSize"] = $quota;
    }
    if (isset($data["mailalias"])) {
        $attr["mailAlias"] = $data["mailalias"];
    }
    if (isset ($data["transes"]) && count($data["transes"]) != 0) {
        $attr["mailForwardingAddr"] = $data["transes"];
    }

    /* LDAPϿ */
    $add_dn = sprintf(ADD_DN, $mail, $web_conf["ldapusersuffix"], $web_conf["ldapbasedn"]);
    $ret = LDAP_add_entry($add_dn, $attr);
    if ($ret != LDAP_OK) {
        return FALSE;
    }

    return TRUE;
}


/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg  = new my_page();
if (isset($_POST["sk"])) {
    $sesskey = $_POST["sk"];
}

/* ɥᥤ */
$domain = $_SERVER['DOMAIN'];

/* եɹ */
$ret = read_web_conf();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(null, null);
    exit (1);
}

/* Ź沽Υѥ򥻥å */
$admkey_file = BASEDIR . ETCDIR . $domain . "/" . ADMKEY;

/* å */
if (isset($sesskey) === FALSE) {
    header("Location: index.php?e=2");
    exit (1);
}

/* åå */
if (is_sysadm($sesskey) !== TRUE) {
    header("Location: index.php?e=1");
    exit (1);
}

/* 顼å */
$err_msg = "";

/***********************************************************
 * main
 **********************************************************/
/* ʬ */

if (isset($_POST["add"])) {
    $mode = POST_ADD_MODE;

    /* ϥǡΥå */
    if (check_add_data($_POST) === FALSE ||
        add_user($_POST) === FALSE) {
        result_log(OPERATION . ":NG:" . $err_msg);
    } else {
        $dispattr = $web_conf['displayuser'];
        if (isset($attr[$dispattr])) {
            $dispusr = $attr[$dispattr];
        } else {
            $dispusr = "";
        }

        $err_msg = "桼ɲäޤ(" . $dispusr . ")";
        result_log(OPERATION . ":OK:" . $err_msg);
        
        /* 桼˥塼̤ */
        dgp_location("admin_user_menu.php", $err_msg);
        exit;
    }
} elseif(isset($_POST["cancel"])) {

    /* 桼˥塼̤ */
    dgp_location("admin_user_menu.php", $err_msg);
    exit;

} else {
    $mode = ADD_MODE;
}

/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
$pg->display($topic, MY_TAB);

?>
