<?php

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/***********************************************************
 * ѥ桼
 *
 * $RCSfile: index.php,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2010/04/22 01:52:47 $
 **********************************************************/

include_once("../../initial");
include_once("lib/dglibpostldapadmin");
include_once("lib/dglibcommon");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibldap");

/********************************************************
ƥڡ
*********************************************************/

define("OPERATION",  "桼ȸ");

define("STATUS_INPUT",  0);
define("STATUS_SEARCH", 1);

/***********************************************************
 * 饹: ˥塼
 **********************************************************/
Class my_page extends page {

    /***********************************************************
     * ܥǥɽʥС饤ɡ
     **********************************************************/
    function display_body() {
        print_form();
    }
};

/*********************************************************
 * print_form
 *
 * ϥե
 *
 * []
 *        ʤ
 *
 * [֤]
 *        ʤ
 *
 **********************************************************/
function print_form()
{
    global $web_conf;
    global $status;
    global $sesskey;
    global $form_name;

    if (isset($form_name)) {
        $form_name = htmlspecialchars($form_name);

        /* ޥå */
        if ($_POST["name_match"] == 0) {
            $name_inc_flg = "selected";
            $name_mat_flg = "";
        } elseif ($_POST["name_match"] == 1) {
            $name_mat_flg = "selected";
            $name_inc_flg = "";
        }
    } else {
        $form_name ="";
        $name_inc_flg = "selected";
        $name_mat_flg = "";
    }

    print <<<EOD

<form method="post" name="all" action="index.php">
<b>桼θ</b><br><br>
<table class="normal">
    <tr>
        <td class="normal" style="text-align:right;">
          桼̾
        </td>
        <td class="normal">
          <input type="text" size="30" name="form_name" value="{$form_name}" maxlength="256">
          <select name="name_match">
              <option value="0" {$name_inc_flg}>ޤ</option>
              <option value="1" {$name_mat_flg}>Ȱפ</option>
          </select>
        </td>
    </tr>
</table>

<br>
<input type="hidden" name="sk" value="$sesskey">
<input type="submit" name="search" value="    ">
<input type="submit" name="csvdownload" value="CSV">
EOD;

    if($status == STATUS_INPUT) {
        print_title(0, null);
    } else {
        print_result();
    }
        print <<<EOD
</table>
</form>
EOD;
}

/*********************************************************
 * print_title
 *
 * ̤Υȥ
 *
 * []
 *          $sum     ̤ι׿
 *          $filter  ѥե륿
 *
 * [֤]
 *          ʤ
 *
 **********************************************************/
function print_title($sum, $filter)
{
    global $web_conf;
    global $sesskey;
    global $page;
    global $filter_disp;
    global $url_data;

    /* ڡֹ0ϤޤäƤ */
    $all_page = (int) ceil(($sum / $web_conf[$url_data["script"]]["lineperpage"]));
    if ($all_page == 0) {
        $all_page = 1;
    }

    /* ڡʾοϤäƤǸΥڡɽ */
    if ($all_page < $page + 1) {
        $page = $all_page - 1;
    }

    /* ɽƤǸΰ硢Υڡɽ */
    $ret = $sum % $all_page;
    if ($ret == 0 && $all_page < $page + 1) {
        $page = $page - 1;
    } 

    if ($page != 0) {
        $tmp = $page - 1;
        $pre = "<a href=\"#\" onClick=\"allSubmit('index.php', '$tmp', '')\">ڡ</a>";
        $next = "";
    } else {
        $pre = "";
        $next = "";
    }

    if ($page != $all_page - 1) {
        $tmp = $page + 1;
        $next = "<a href=\"#\" onClick=\"allSubmit('index.php', '$tmp', '')\">ڡ</a>";
    }

    print <<<EOD

<script type="text/javascript">
<!--
function allSubmit(url, page, dn) {
    document.all.action = url;
    document.all.page.value = page;
    document.all.dn.value = dn;
    document.all.submit();
}
// -->
</script>

<br>
<br>
<input type="hidden" name="filter" value="{$filter_disp}">
<input type="hidden" name="page" value="{$page}">
<input type="hidden" name="sk" value="{$sesskey}">
<input type="hidden" name="dn">
<table class="table">
    <tr>
        <td class="search_sum">[ $sum ]</td>
        <td colspan="5" class="search_tmp" style="border:1px solid #000000;">
          <table class="guide" align="right">
            <tr>
              <td class="search_prev">$pre</td>
              <td class="search_next">$next</td>
            </tr>
          </table>  
        </td>
    </tr>
    <tr>
        <td class="search_name">桼̾</td>
        <td class="search_name">᡼륨ꥢ</td>
        <td class="search_trans">᡼žɥ쥹</td>
        <td class="search_quota">᡼</td>
        <td class="search_ref"></td>
    </tr>

EOD;

}

/*********************************************************
 * print_result
 *
 * ̽
 *
 * []
 *       ʤ
 *
 * [֤]
 *       ʤ
 **********************************************************/
function print_result()
{
    global $web_conf;
    global $ldap_result;
    global $dispusr;
    global $filter;
    global $page;
    global $limit_adm;
    global $url_data;

    /* ̤ɽ°̾ǥ */
    if (isset($ldap_result)) {
        usort($ldap_result, "user_sort");
        reset($ldap_result);
        $sum = count($ldap_result);
    } else {
        $sum = 0;
    }

    /* ơ֥Υȥɽ */
    print_title($sum, $filter);

    $i = $web_conf[$url_data["script"]]["lineperpage"] * $page;
    $tmp = $i + $web_conf[$url_data["script"]]["lineperpage"];

    /* ɽ */
    $max = ($tmp < $sum) ? $tmp : $sum;

    while ($i < $max) {

        /* dnǼ */
        $userdn = $ldap_result[$i]["dn"];
        $userdn = base64_encode($userdn);
        $userdn = str_rot13($userdn);
        $userdn = htmlspecialchars($userdn);

        /*  */
        $alias = "";
        $trans = "";
        $quota = "";

        /* 桼̾Ǽ */
        $name = htmlspecialchars($ldap_result[$i][$dispusr][0]);

        /* ꥢǼ */
        if (isset($ldap_result[$i]["mailAlias"])) {
            $mailalias = htmlspecialchars($ldap_result[$i]["mailAlias"][0]);
            $part = explode("@", $mailalias, 2);
            $alias = $part[0];
        }

        /* žɥ쥹Ǽ */
        if (isset($ldap_result[$i]['mailForwardingAddr'][0])) {
            if ($ldap_result[$i]['mailForwardingAddr'][0] !=
                $ldap_result[$i]['mail'][0]) {
                $trans = $ldap_result[$i]['mailForwardingAddr'][0];
            } else {
                $trans = $ldap_result[$i]['mailForwardingAddr'][1];
            }
        }

         /* ᡼̤Ǽ */
        if (isset($ldap_result[$i]["quotaSize"][0])) {

            /* եΥñ̤ʸѴ */
            $conf_quota = strtolower($web_conf[$url_data["script"]]["quotaunit"]);

            /* եƤˤäñ̤Ѳ */
            switch ($conf_quota) {
                case "b":
                    $quota = $ldap_result[$i]["quotaSize"][0] . "bytes";
                    break;
                case "kb":
                    $quota = $ldap_result[$i]["quotaSize"][0] . "Kbytes";
                    break;
                case "mb":
                    $quota = $ldap_result[$i]["quotaSize"][0] . "Mbytes";
                    break;
                case "gb":
                    $quota = $ldap_result[$i]["quotaSize"][0] . "Gbytes";
                    break;
            }
        }

    print <<<EOD
    <tr>
        <td class="value">{$name}</td>
        <td class="value_alias">{$alias}</td>
        <td class="value_trans">{$trans}</td>
        <td class="value_right">{$quota}</td>
        <td class="value_center"><a href="#" onClick="allSubmit('mod.php', '$page', '$userdn')">Խ</a></td>
    </tr>

EOD;
        $i++;
    }

}

/*********************************************************
 * csv_output
 *
 * CSVեνϤ򤪤ʤ
 *
 * []
 *
 * [֤]
 *           TRUE     
 *           FALSE    ۾
 *
 **********************************************************/
function csv_output(){

    global $dispusr;
    global $ldap_result;
    global $domain;

    /* ̤ɽ°̾ǥ */
    usort($ldap_result, "user_sort");
    reset($ldap_result);

    header("Content-Disposition: attachment; filename=userdata_$domain.csv");
    header("Content-Type: application/octet-stream");

    foreach ($ldap_result as $userdata) {

        /*  */
        $csvdata = array();

        /* 桼̾Ǽ */
        array_push($csvdata, $userdata[$dispusr][0]);

        /* ᡼̤Ǽ */
        if (isset($userdata["quotaSize"])) {
            $quota = $userdata["quotaSize"][0];
            array_push($csvdata, $quota);
        } else {
            array_push($csvdata, "");
        }

        /* ꥢǼ */
        if (isset($userdata["mailAlias"])) {
            $part = explode("@", $userdata["mailAlias"][0], 2);
            array_push($csvdata, $part[0]);
        } else {
            array_push($csvdata, "");
        }

        /* ᡼žɥ쥹Ǽ */
        if (isset($userdata["mailForwardingAddr"])) {
            if (count($userdata["mailForwardingAddr"]) == 1) {
                $trans = $userdata["mailForwardingAddr"][0];
                $reserve = 1;
            } else {
                if ($userdata["mailForwardingAddr"][0] !=
                    $userdata["mail"][0]) {
                    $trans = $userdata["mailForwardingAddr"][0];
                } else {
                    $trans = $userdata["mailForwardingAddr"][1];
                }
                $reserve = 0;
            }

            array_push($csvdata, $trans);
            array_push($csvdata, $reserve);
        } else {
            array_push($csvdata, "");
            array_push($csvdata, "");
        }

        $csvline = mk_csv_line($csvdata);
        print("$csvline\r\n");
    }
}

/*********************************************************
 * mk_csv_line
 *
 * Ϥ줿󤫤CSVեΰԤ
 *
 * []
 *           $csvdata CSVѴ
 *
 * [֤]
 *           $csvline CSVѴ줿ʸ
 *
 **********************************************************/
function mk_csv_line($csvdata) {

    $csvline = implode(",", $csvdata);
    
    return $csvline;
}

/*********************************************************
 * form_check
 *
 * ϥեηå
 *
 * []
 *           $data    åǡϢ
 *
 * [֤]
 *           TRUE     
 *           FALSE    顼
 *
 **********************************************************/
function form_check($data)
{
    global $err_msg;

    /* 桼̾ηå */
    $ret = check_search_name($data['form_name']);
    if ($ret === FALSE) {
        $err_msg = "桼̾ηǤ";
        return FALSE;
    }	

    /* 桼Υå */
    $ret = check_flg($data['name_match']);
    if ($ret === FALSE) {
        $err_msg = "桼̾θ郎Ǥ";
        return FALSE;
    }	

    return TRUE;
}

/***********************************************************
 * 
 **********************************************************/
/* 󥹥󥹺 */
$pg = new my_page();

/* եϤ줿 */
if (isset($_POST['form_name'])) {
    $form_name = $_POST['form_name'];
}

/* ơ */
if (isset($_POST["search"]) || isset($_POST["filter"]) ||
    isset($_POST["csvdownload"])) {
    $status = STATUS_SEARCH;
} else {
    $status = STATUS_INPUT;
}

/* ե롦ִեɹåå */
$ret = init();
if ($ret === FALSE) {
    $sys_err = TRUE;
    $pg->display(NULL);
    exit (1);
}

/***********************************************************
 * main
 **********************************************************/
/* ɽ° */
$dispusr = $web_conf[$url_data['script']]['displayuser'];

/* ʬ */
if ($status == STATUS_SEARCH) {
    if ((isset($_POST["search"]) || isset($_POST["csvdownload"])) &&
         form_check($_POST) === FALSE) {
        /* ܥ󤬲졢ϤǤСϤʤ */
        $status = STATUS_INPUT;
        $logstr = OPERATION . ":NG:" . $err_msg;
        result_log($logstr);
    } else {
        /* Υե륿 */
        if ((!isset($_POST["search"]) && !isset($_POST["csvdownload"])) &&
             $_POST["filter"] != "") {
            /* եϤ줿ͤʣ粽 */
            if (isset($_POST['form_name'])) {
                $form_name = str_rot13($_POST['form_name']);
                $form_name = base64_decode($form_name);
            }

            /* ڡͥå */
            if (is_num_check($_POST["page"]) === FALSE) {
                $err_msg = "ڡͤǤ";
                $sys_err = TRUE;
                $pg->display(NULL);
                exit (1);
            }
            $page = $_POST["page"];

            /* ե륿ʣ粽 */
            if (sess_key_decode($_POST["filter"], $filter) === FALSE) {
                $sys_err = TRUE;
                $pg->display(NULL);
                exit (1);
            }

            /* ե륿ηå */
            $fdata = explode(':', $filter);
            if (count($fdata) != 3) {
                $err_msg = "ե륿ηǤ";
                $sys_err = TRUE;
                $pg->display(NULL);
                exit (1);
            }
            $filter = $fdata[1];

        } else {
            /* ե륿 */
            $filter = mk_filter($_POST["form_name"], $_POST["name_match"]);

            /* Τϡɽ°ĥȥΤ */
            $filter = "(&($dispusr=*)$filter)";
            $page = 0;
        }
        $search_dn = sprintf(SEARCH_DN, $web_conf[$url_data["script"]]["ldapusersuffix"], 
                                        $web_conf[$url_data["script"]]["ldapbasedn"]);
        $ret = main_get_entry($search_dn, $filter, array(),
                              $web_conf[$url_data['script']]['ldapscope'], $ldap_result);
        if ($ret == LDAP_ERR_NODATA ) {
            $err_msg = "ꤵ줿桼ϸĤޤǤ";
            $logstr = OPERATION . ":NG:" . $err_msg;
            result_log($logstr);
        } elseif ($ret != LDAP_OK) {
            $status = STATUS_INPUT;
            $logstr = OPERATION . ":NG:" . $err_msg;
            result_log($logstr);
        }

        /* ե륿ΰŹ沽 */
        if (sess_key_make($filter, "", $filter_disp) === FALSE) {
            $sys_err = TRUE;
            $pg->display(NULL);
            exit (1);
        }

        /* ¾Υڡۤåɽ */
        if (isset($_POST["msg"])) {
            $err_msg = htmlspecialchars($_POST["msg"]);
        }
    }
} 

/***********************************************************
 * ɽ
 **********************************************************/

/* ڡν */
if (isset($_POST['csvdownload']) && count($ldap_result) > 0) {
    $err_msg = "CSVեɤޤ";
    $logstr = OPERATION . ":OK:" . $err_msg;
    result_log($logstr);
    csv_output();
    exit(0);
} else {
    $pg->display(CONTENT);
}
?>
