/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.component.tabview.Tab;
import org.primefaces.renderkit.CoreRenderer;

public class AccordionPanelRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AccordionPanel accordionPanel = (AccordionPanel)component;
        String clientId = accordionPanel.getClientId(facesContext);
        String activeTabIndex = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + "_container_state");
        if (activeTabIndex != null) {
            if (activeTabIndex.equals("")) {
                accordionPanel.setActiveIndex(null);
            } else {
                accordionPanel.setActiveIndex(activeTabIndex);
            }
        }
        this.encodeScript(facesContext, accordionPanel);
        this.encodeMarkup(facesContext, accordionPanel);
    }

    private void encodeScript(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = accordionPanel.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)accordionPanel);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(var + " = new PrimeFaces.widget.AccordionPanel('" + clientId + "_container',");
        writer.write("{");
        writer.write("collapsible:true");
        writer.write(",width:'100%'");
        if (accordionPanel.getActiveIndex() != null) {
            writer.write(",expandItem:[" + accordionPanel.getActiveIndex() + "]");
        } else {
            writer.write(",expandItem:[]");
        }
        if (accordionPanel.isMultiple()) {
            writer.write(",expandable:true");
        }
        if (accordionPanel.getSpeed() != 0.5) {
            writer.write(",animationSpeed:" + accordionPanel.getSpeed());
        }
        if (!accordionPanel.isAnimate()) {
            writer.write(",animate:false");
        }
        if (accordionPanel.isHover()) {
            writer.write(",hoverActivated:true");
        }
        if (accordionPanel.getHoverDelay() != 500) {
            writer.write(",hoverTimeout:" + accordionPanel.getSpeed());
        }
        writer.write("});});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = accordionPanel.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (accordionPanel.getStyle() != null) {
            writer.writeAttribute("style", (Object)accordionPanel.getStyle(), null);
        }
        if (accordionPanel.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)accordionPanel.getStyleClass(), null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        this.encodeTabs(facesContext, accordionPanel);
        writer.endElement("ul");
        this.encodeStateHolder(facesContext, accordionPanel);
        writer.endElement("div");
    }

    private void encodeStateHolder(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = accordionPanel.getClientId(facesContext);
        String stateHolderId = clientId + "_container_state";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)stateHolderId, null);
        writer.writeAttribute("name", (Object)stateHolderId, null);
        if (accordionPanel.getActiveIndex() != null) {
            writer.writeAttribute("value", (Object)accordionPanel.getActiveIndex(), null);
        }
        writer.endElement("input");
    }

    private void encodeTabs(FacesContext facesContext, AccordionPanel accordionPanel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        for (UIComponent kid : accordionPanel.getChildren()) {
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("li", null);
            writer.startElement("p", null);
            if (tab.getTitle() != null) {
                writer.write(tab.getTitle());
            }
            writer.endElement("p");
            writer.startElement("div", null);
            this.renderChild(facesContext, (UIComponent)tab);
            writer.endElement("div");
            writer.endElement("li");
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

