/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.imageswitch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIGraphic;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.imageswitch.ImageSwitch;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageSwitchRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ImageSwitch imageSwitch = (ImageSwitch)component;
        this.encodeScript(facesContext, imageSwitch);
        this.encodeMarkup(facesContext, imageSwitch);
    }

    private void encodeScript(FacesContext facesContext, ImageSwitch imageSwitch) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = imageSwitch.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)imageSwitch);
        String imageClientId = ((UIComponent)imageSwitch.getChildren().get(0)).getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(widgetVar + " = new PrimeFaces.widget.ImageSwitch('" + imageClientId + "',{");
        writer.write("effect:'" + imageSwitch.getEffect() + "'");
        writer.write(",speed:" + imageSwitch.getSpeed());
        writer.write(",slideshowSpeed:" + imageSwitch.getSlideshowSpeed());
        writer.write(",slideshowAuto:" + imageSwitch.isSlideshowAuto());
        writer.write("},");
        writer.write(this.getImagesAsJSArray(facesContext, imageSwitch));
        writer.write(");\n");
        writer.write("});");
        writer.endElement("script");
    }

    private List<String> getImages(FacesContext facesContext, ImageSwitch imageSwitch) {
        ArrayList<String> images = new ArrayList<String>();
        for (UIComponent child : imageSwitch.getChildren()) {
            UIGraphic image;
            if (!(child instanceof UIGraphic) || !(image = (UIGraphic)child).isRendered()) continue;
            images.add(this.getResourceURL(facesContext, image.getUrl()));
        }
        return images;
    }

    private void encodeMarkup(FacesContext facesContext, ImageSwitch imageSwitch) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = imageSwitch.getClientId(facesContext);
        writer.startElement("span", (UIComponent)imageSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        UIComponent firstChild = (UIComponent)imageSwitch.getChildren().get(0);
        this.renderChild(facesContext, firstChild);
        writer.endElement("span");
    }

    private String getImagesAsJSArray(FacesContext facesContext, ImageSwitch imageSwitch) {
        List<String> images = this.getImages(facesContext, imageSwitch);
        StringBuilder array = new StringBuilder();
        array.append("[");
        Iterator<String> iterator = images.iterator();
        while (iterator.hasNext()) {
            array.append("'");
            array.append(iterator.next());
            array.append("'");
            if (!iterator.hasNext()) continue;
            array.append(",");
        }
        array.append("]");
        return array.toString();
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

