/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.media.Media;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.MediaPlayerFactory;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.HTML;

public class MediaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Media media = (Media)component;
        MediaPlayer player = this.resolvePlayer(facesContext, media);
        if (AgentUtils.isIE(facesContext)) {
            this.encodeObjectTag(facesContext, media, player);
        } else {
            this.encodeEmbedTag(facesContext, media, player);
        }
    }

    private void encodeObjectTag(FacesContext facesContext, Media media, MediaPlayer player) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String src = this.getResourceURL(facesContext, media.getValue());
        writer.startElement("object", (UIComponent)media);
        writer.writeAttribute("classid", (Object)player.getClassId(), null);
        if (player.getCodebase() != null) {
            writer.writeAttribute("codebase", (Object)player.getCodebase(), null);
        }
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)media, HTML.MEDIA_ATTRS);
        this.encodeParam(writer, player.getSourceParam(), src, false);
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), false);
        }
        writer.endElement("object");
    }

    private void encodeEmbedTag(FacesContext facesContext, Media media, MediaPlayer player) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String src = this.getResourceURL(facesContext, media.getValue());
        writer.startElement("embed", (UIComponent)media);
        writer.writeAttribute("pluginspage", (Object)player.getPlugingPage(), null);
        writer.writeAttribute("src", (Object)src, null);
        if (media.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)media.getStyleClass(), null);
        }
        if (player.getType() != null) {
            writer.writeAttribute("type", (Object)player.getType(), null);
        }
        this.renderPassThruAttributes(facesContext, (UIComponent)media, HTML.MEDIA_ATTRS);
        for (UIComponent child : media.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter param = (UIParameter)child;
            this.encodeParam(writer, param.getName(), param.getValue(), true);
        }
        writer.endElement("embed");
    }

    private void encodeParam(ResponseWriter writer, String name, Object value, boolean asAttribute) throws IOException {
        if (value == null) {
            return;
        }
        if (asAttribute) {
            writer.writeAttribute(name, value, null);
        } else {
            writer.startElement("param", null);
            writer.writeAttribute("name", (Object)name, null);
            writer.writeAttribute("value", (Object)value.toString(), null);
            writer.endElement("param");
        }
    }

    private MediaPlayer resolvePlayer(FacesContext facesContext, Media media) {
        if (media.getPlayer() != null) {
            return MediaPlayerFactory.getPlayer(media.getPlayer());
        }
        Map<String, MediaPlayer> players = MediaPlayerFactory.getPlayers();
        String[] tokens = media.getValue().split("\\.");
        String type = tokens[tokens.length - 1];
        for (MediaPlayer mp : players.values()) {
            if (!mp.isAppropriatePlayer(type)) continue;
            return mp;
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for media component '" + media.getClientId(facesContext) + "', cannot play source:" + media.getValue());
    }
}

