/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.touch.component.view;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.touch.component.navbarcontrol.NavBarControl;
import org.primefaces.touch.component.view.View;
import org.primefaces.util.ComponentUtils;

public class ViewRenderer
extends CoreRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        View view = (View)component;
        writer.startElement("div", (UIComponent)view);
        writer.writeAttribute("id", (Object)view.getClientId(facesContext), "id");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"toolbar", null);
        writer.startElement("h1", null);
        if (view.getTitle() != null) {
            writer.write(view.getTitle());
        }
        writer.endElement("h1");
        this.encodeNavBarControls(facesContext, view);
        writer.endElement("div");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("div");
    }

    private void encodeNavBarControls(FacesContext facesContext, View view) throws IOException {
        String styleClass;
        String viewId;
        String href;
        ResponseWriter writer = facesContext.getResponseWriter();
        NavBarControl leftControl = (NavBarControl)view.getFacet("leftNavBar");
        NavBarControl rightControl = (NavBarControl)view.getFacet("rightNavBar");
        if (leftControl != null) {
            href = "#";
            viewId = leftControl.getView();
            String string = styleClass = leftControl.getType() != null ? leftControl.getType() : "";
            if (leftControl.getEffect() != null) {
                styleClass = styleClass + " " + leftControl.getEffect();
            }
            writer.startElement("a", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (viewId != null) {
                href = viewId.equals("home") ? href + "home" : href + ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), leftControl.getView()).getClientId(facesContext);
            }
            writer.writeAttribute("href", (Object)href, null);
            if (leftControl.getLabel() != null) {
                writer.write(leftControl.getLabel());
            }
            writer.endElement("a");
        }
        if (rightControl != null) {
            href = "#";
            viewId = rightControl.getView();
            String string = styleClass = rightControl.getType() != null ? rightControl.getType() : "";
            if (rightControl.getEffect() != null) {
                styleClass = styleClass + " " + rightControl.getEffect();
            }
            writer.startElement("a", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (viewId != null) {
                href = viewId.equals("home") ? href + "home" : href + ComponentUtils.findComponentById(facesContext, (UIComponent)facesContext.getViewRoot(), rightControl.getView()).getClientId(facesContext);
            }
            writer.writeAttribute("href", (Object)href, null);
            if (rightControl.getLabel() != null) {
                writer.write(rightControl.getLabel());
            }
            writer.endElement("a");
        }
    }
}

