/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.carousel;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.carousel.Carousel;
import org.primefaces.renderkit.CoreRenderer;

public class CarouselRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Carousel carousel = (Carousel)component;
        if (this.isPostback(facesContext)) {
            this.restoreState(facesContext, carousel);
        }
        this.encodeCarouselScript(facesContext, carousel);
        this.encodeCarouselMarkup(facesContext, carousel);
    }

    private void encodeCarouselMarkup(FacesContext facesContext, Carousel carousel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = carousel.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)this.getContainerElementId(clientId), null);
        writer.startElement("ol", null);
        carousel.setRowIndex(-1);
        for (int i = 0; i < carousel.getRowCount(); ++i) {
            carousel.setRowIndex(i);
            writer.startElement("li", null);
            writer.writeAttribute("id", (Object)carousel.getClientId(facesContext), null);
            this.renderChildren(facesContext, (UIComponent)carousel);
            writer.endElement("li");
        }
        carousel.setRowIndex(-1);
        writer.endElement("ol");
        writer.endElement("div");
        this.encodeHiddenStateField(facesContext, this.getPagerStateHolderId(clientId));
        this.encodeHiddenStateField(facesContext, this.getSelectedItemStateHolderId(clientId));
        writer.endElement("div");
    }

    private void encodeCarouselScript(FacesContext facesContext, Carousel carousel) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = carousel.getClientId(facesContext);
        String carouselVar = this.createUniqueWidgetVar(facesContext, (UIComponent)carousel);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("YAHOO.util.Event.addListener(window, \"load\", function() {\n");
        writer.write(carouselVar + " = new PrimeFaces.widget.Carousel(\"" + this.getContainerElementId(clientId) + "\", {pagerStateHolder:\"" + this.getPagerStateHolderId(clientId) + "\"" + ", selectedItemStateHolder:\"" + this.getSelectedItemStateHolderId(clientId) + "\"});\n");
        if (carousel.isCircular()) {
            writer.write(carouselVar + ".set(\"isCircular\", true);\n");
        }
        if (carousel.isVertical()) {
            writer.write(carouselVar + ".set(\"isVertical\", true);\n");
        }
        if (carousel.getRows() != 0) {
            writer.write(carouselVar + ".set(\"numVisible\"," + carousel.getRows() + ");\n");
        }
        if (carousel.getFirst() != 0) {
            writer.write(carouselVar + ".set(\"firstVisible\"," + carousel.getFirst() + ");\n");
        }
        if (carousel.getAutoPlayInterval() != 0) {
            writer.write(carouselVar + ".set(\"autoPlayInterval\"," + carousel.getAutoPlayInterval() + ");\n");
        }
        if (carousel.getScrollIncrement() != 1) {
            writer.write(carouselVar + ".set(\"scrollIncrement\"," + carousel.getScrollIncrement() + ");\n");
        }
        if (carousel.getRevealAmount() != 0) {
            writer.write(carouselVar + ".set(\"revealAmount\"," + carousel.getRevealAmount() + ");\n");
        }
        if (carousel.isAnimate()) {
            writer.write(carouselVar + ".set(\"animation\", {speed:" + carousel.getSpeed());
            if (carousel.getEffect() != null) {
                writer.write(",effect:YAHOO.util.Easing." + carousel.getEffect() + "});\n");
            } else {
                writer.write("});\n");
            }
        }
        writer.write(carouselVar + ".render();\n");
        if (carousel.getSelectedItem() != 0) {
            writer.write(carouselVar + ".set(\"selectedItem\"," + carousel.getSelectedItem() + ");\n");
        }
        writer.write(carouselVar + ".show();\n");
        if (carousel.isCircular() && carousel.getAutoPlayInterval() != 0) {
            writer.write(carouselVar + ".startAutoPlay();\n");
        }
        writer.write("});\n");
        writer.endElement("script");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    private void restoreState(FacesContext facesContext, Carousel carousel) {
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = carousel.getClientId(facesContext);
        String firstValue = (String)params.get(this.getPagerStateHolderId(clientId));
        String selectedItemIndex = (String)params.get(this.getSelectedItemStateHolderId(clientId));
        if (firstValue != null && !firstValue.equals("")) {
            carousel.setFirst(Integer.parseInt(firstValue));
        }
        if (selectedItemIndex != null && !selectedItemIndex.equals("")) {
            carousel.setSelectedItem(Integer.parseInt(selectedItemIndex));
        }
    }

    private String getContainerElementId(String clientId) {
        return clientId + ":container";
    }

    private String getPagerStateHolderId(String clientId) {
        return clientId + ":pagerstate";
    }

    private String getSelectedItemStateHolderId(String clientId) {
        return clientId + ":selecteditem";
    }

    private void encodeHiddenStateField(FacesContext facesContext, String id) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
    }
}

