/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart.pie;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.chart.BaseChartRenderer;
import org.primefaces.component.chart.UIChart;
import org.primefaces.component.chart.pie.PieChart;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceUtils;

public class PieChartRenderer
extends BaseChartRenderer
implements PartialRenderer {
    protected void encodeChartScript(FacesContext facesContext, UIChart uichart) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        PieChart chart = (PieChart)uichart;
        String clientId = chart.getClientId(facesContext);
        String categoryFieldName = this.getFieldName(chart.getValueExpression("categoryField"));
        String dataFieldName = this.getFieldName(chart.getValueExpression("dataField"));
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady(\"" + clientId + "\", function() {\n");
        if (!chart.isLive()) {
            this.encodeLocalData(facesContext, chart, categoryFieldName, dataFieldName);
        }
        this.encodeDataSource(facesContext, chart, categoryFieldName, dataFieldName);
        this.encodeChartWidget(facesContext, chart, clientId, categoryFieldName, dataFieldName);
        writer.write("});\n");
        writer.endElement("script");
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ((ServletResponse)facesContext.getExternalContext().getResponse()).setContentType("application/json");
        PieChart chart = (PieChart)component;
        String categoryFieldName = this.getFieldName(chart.getValueExpression("categoryField"));
        String dataFieldName = this.getFieldName(chart.getValueExpression("dataField"));
        writer.write("{");
        writer.write("\"LiveChartDataResponse\" : {");
        writer.write("\"Data\" : [");
        Collection value = (Collection)chart.getValue();
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            facesContext.getExternalContext().getRequestMap().put(chart.getVar(), iterator.next());
            String categoryFieldValue = chart.getValueExpression("categoryField").getValue(facesContext.getELContext()).toString();
            String dataFieldValue = chart.getValueExpression("dataField").getValue(facesContext.getELContext()).toString();
            writer.write("{\"" + categoryFieldName + "\":\"" + categoryFieldValue + "\",\"" + dataFieldName + "\":" + dataFieldValue + "}");
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write("}");
        writer.write("}");
    }

    private void encodeLocalData(FacesContext facesContext, UIChart chart, String categoryFieldName, String dataFieldName) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("var " + this.getLocalDataVar(chart) + " = [");
        Collection value = (Collection)chart.getValue();
        Iterator iterator = value.iterator();
        while (iterator.hasNext()) {
            facesContext.getExternalContext().getRequestMap().put(chart.getVar(), iterator.next());
            String categoryFieldValue = chart.getValueExpression("categoryField").getValue(facesContext.getELContext()).toString();
            String dataFieldValue = chart.getValueExpression("dataField").getValue(facesContext.getELContext()).toString();
            writer.write("{" + categoryFieldName + ":'" + categoryFieldValue + "'," + dataFieldName + ":" + dataFieldValue + "}");
            if (!iterator.hasNext()) continue;
            writer.write(",\n");
        }
        writer.write("];\n");
    }

    private void encodeDataSource(FacesContext facesContext, UIChart chart, String categoryFieldName, String dataFieldName) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String dataSourceVar = this.getDataSourceVar(chart);
        if (chart.isLive()) {
            writer.write("var " + dataSourceVar + " = new YAHOO.util.DataSource(\"" + this.getActionURL(facesContext) + "\");\n");
            writer.write(dataSourceVar + ".connMethodPost = true;\n");
            writer.write(dataSourceVar + ".responseType=YAHOO.util.DataSource.TYPE_JSON;\n");
            writer.write(dataSourceVar + ".responseSchema = {resultsList:\"LiveChartDataResponse.Data\", fields:[\"" + categoryFieldName + "\",\"" + dataFieldName + "\"]};\n");
        } else {
            writer.write("var " + dataSourceVar + " = new YAHOO.util.DataSource(" + this.getLocalDataVar(chart) + ");\n");
            writer.write(dataSourceVar + ".responseType=YAHOO.util.DataSource.TYPE_JSARRAY;\n");
            writer.write(dataSourceVar + ".responseSchema = {fields:[\"" + categoryFieldName + "\",\"" + dataFieldName + "\"]};\n");
        }
    }

    private void encodeChartWidget(FacesContext facesContext, PieChart chart, String clientId, String categoryFieldName, String dataFieldName) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write(this.getChartVar(chart) + " = new YAHOO.widget.PieChart(\"" + clientId + "\", " + this.getDataSourceVar(chart) + ",{");
        writer.write("categoryField:\"" + categoryFieldName + "\"");
        writer.write(",dataField:\"" + dataFieldName + "\"");
        writer.write(",expressInstall:\"" + ResourceUtils.getResourceURL(facesContext, "/yui/assets/expressinstall.swf") + "\"");
        if (chart.getWmode() != null) {
            writer.write(",wmode:\"" + chart.getWmode() + "\"");
        }
        if (chart.isLive()) {
            writer.write(",polling:" + chart.getRefreshInterval());
            writer.write(",request:PrimeFaces.widget.ChartUtils.createPollingParams(\"" + clientId + "\")");
        }
        if (chart.getStyle() != null) {
            writer.write(",style:" + chart.getStyle() + "");
        }
        if (chart.getSeriesStyle() != null) {
            writer.write(",series: [{ style: " + chart.getSeriesStyle() + " }]");
        }
        if (chart.getDataTipFunction() != null) {
            writer.write(",dataTipFunction:" + chart.getDataTipFunction());
        }
        writer.write("});\n");
        if (chart.getItemSelectListener() != null) {
            this.encodeItemSelectEvent(facesContext, chart);
        }
    }
}

