/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.RendererUtils;

public class TabViewRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        TabView tabView;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String activeIndexValue = (String)params.get((tabView = (TabView)component).getClientId(facesContext) + "_activeIndex");
        if (!this.isValueEmpty(activeIndexValue)) {
            tabView.setActiveIndex(Integer.parseInt(activeIndexValue));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TabView tabView = (TabView)component;
        this.encodeScript(facesContext, tabView);
        this.encodeMarkup(facesContext, tabView);
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        TabView tabView = (TabView)component;
        Tab activeTab = (Tab)((Object)tabView.getChildren().get(tabView.getActiveIndex()));
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("text/xml");
        ResponseWriter writer = facesContext.getResponseWriter();
        try {
            writer.write("<partialResponse>");
            writer.write("<tabContent>");
            RendererUtils.startCDATA(facesContext);
            this.renderChildren(facesContext, (UIComponent)activeTab);
            RendererUtils.endCDATA(facesContext);
            writer.write("</tabContent>");
            writer.write("<state>");
            RendererUtils.startCDATA(facesContext);
            StateManager stateManager = facesContext.getApplication().getStateManager();
            stateManager.writeState(facesContext, stateManager.saveView(facesContext));
            RendererUtils.endCDATA(facesContext);
            writer.write("</state>");
            writer.write("</partialResponse>");
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        facesContext.responseComplete();
    }

    private void encodeScript(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        String tabViewVar = this.createUniqueWidgetVar(facesContext, (UIComponent)tabView);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(tabViewVar + " = new PrimeFaces.widget.TabView('" + clientId + "',");
        writer.write("{");
        if (tabView.isDynamic()) {
            writer.write("dynamic:true");
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
            writer.write(",cache:" + tabView.isCache());
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)tabView);
            if (form == null) {
                throw new FacesException("TabView " + clientId + " must be nested inside a form when dynamic content loading is enabled");
            }
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
        } else {
            writer.write("dynamic:false");
        }
        if (tabView.getOrientation() != null) {
            writer.write(",orientation:'" + tabView.getOrientation() + "'");
        }
        if (tabView.isContentTransition()) {
            writer.write(",contentTransition:" + tabView.isContentTransition());
        }
        writer.write("});});\n");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = tabView.getClientId(facesContext);
        int activeIndex = tabView.getActiveIndex();
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)"yui-navset", null);
        this.encodeHeaders(facesContext, tabView, activeIndex);
        this.encodeContents(facesContext, tabView, activeIndex);
        this.encodeActiveIndexHolder(facesContext, tabView);
        writer.endElement("div");
    }

    private void encodeActiveIndexHolder(FacesContext facesContext, TabView tabView) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String paramName = tabView.getClientId(facesContext) + "_activeIndex";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)paramName, null);
        writer.writeAttribute("name", (Object)paramName, null);
        writer.writeAttribute("value", (Object)tabView.getActiveIndex(), null);
        writer.endElement("input");
    }

    private void encodeHeaders(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"yui-nav", null);
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)tabView.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("li", null);
            if (i == activeTabIndex) {
                writer.writeAttribute("class", (Object)"selected", null);
            }
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)("#" + tab.getClientId(facesContext)), null);
            writer.startElement("em", null);
            writer.write(tab.getTitle());
            writer.endElement("em");
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    private void encodeContents(FacesContext facesContext, TabView tabView, int activeTabIndex) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"yui-content", null);
        for (int i = 0; i < tabView.getChildren().size(); ++i) {
            UIComponent kid = (UIComponent)tabView.getChildren().get(i);
            if (!kid.isRendered() || !(kid instanceof Tab)) continue;
            Tab tab = (Tab)kid;
            writer.startElement("div", null);
            if (tabView.isDynamic()) {
                if (i == activeTabIndex) {
                    this.renderChildren(facesContext, (UIComponent)tab);
                }
            } else {
                this.renderChildren(facesContext, (UIComponent)tab);
            }
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

