/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.datatable;

import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.component.api.AjaxComponent;
import org.primefaces.resource.ResourceHolder;
import java.util.Iterator;
import org.primefaces.model.LazyDataModel;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.model.DataModel;
import javax.el.ValueExpression;
import org.primefaces.component.column.Column;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.lang.StringBuffer;


public class DataTable extends UIData implements AjaxComponent {


	public static final String COMPONENT_TYPE = "org.primefaces.component.DataTable";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.DataTableRenderer";

	private java.lang.String _widgetVar;
	private java.lang.Boolean _paginator;
	private java.lang.String _paginatorTemplate;
	private java.lang.String _rowsPerPageTemplate;
	private java.lang.Boolean _scrollable;
	private java.lang.String _width;
	private java.lang.String _height;
	private java.lang.String _firstPageLinkLabel;
	private java.lang.String _previousPageLinkLabel;
	private java.lang.String _nextPageLinkLabel;
	private java.lang.String _lastPageLinkLabel;
	private java.lang.String _selectionMode;
	private java.lang.Object _selection;
	private java.lang.Boolean _dynamic;
	private java.lang.Boolean _lazy;
	private java.lang.String _rowIndexVar;
	private java.lang.String _paginatorPosition;
	private java.lang.String _emptyMessage;
	private java.lang.String _errorMessage;
	private java.lang.String _loadingMessage;
	private java.lang.String _sortAscMessage;
	private java.lang.String _sortDescMessage;
	private java.lang.String _update;
	private java.lang.String _style;
	private java.lang.String _styleClass;
	private java.lang.String _onselectStart;
	private java.lang.String _onselectComplete;
	private java.lang.Boolean _dblClickSelect;
	private java.lang.Integer _page;
	public DataTable() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/paginator/assets/skins/sam/paginator.css");
			resourceHolder.addResource("/yui/datatable/assets/skins/sam/datatable.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/json/json-min.js");
			resourceHolder.addResource("/yui/datasource/datasource-min.js");
			resourceHolder.addResource("/yui/paginator/paginator-min.js");
			resourceHolder.addResource("/yui/datatable/datatable-min.js");
			resourceHolder.addResource("/jquery/jquery.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/datatable/datatable.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public boolean isPaginator() {
		if(_paginator != null )
			return _paginator;

		ValueExpression ve = getValueExpression("paginator");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setPaginator(boolean _paginator) {
		this._paginator = _paginator;
	}

	public java.lang.String getPaginatorTemplate() {
		if(_paginatorTemplate != null )
			return _paginatorTemplate;

		ValueExpression ve = getValueExpression("paginatorTemplate");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setPaginatorTemplate(java.lang.String _paginatorTemplate) {
		this._paginatorTemplate = _paginatorTemplate;
	}

	public java.lang.String getRowsPerPageTemplate() {
		if(_rowsPerPageTemplate != null )
			return _rowsPerPageTemplate;

		ValueExpression ve = getValueExpression("rowsPerPageTemplate");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setRowsPerPageTemplate(java.lang.String _rowsPerPageTemplate) {
		this._rowsPerPageTemplate = _rowsPerPageTemplate;
	}

	public boolean isScrollable() {
		if(_scrollable != null )
			return _scrollable;

		ValueExpression ve = getValueExpression("scrollable");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setScrollable(boolean _scrollable) {
		this._scrollable = _scrollable;
	}

	public java.lang.String getWidth() {
		if(_width != null )
			return _width;

		ValueExpression ve = getValueExpression("width");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidth(java.lang.String _width) {
		this._width = _width;
	}

	public java.lang.String getHeight() {
		if(_height != null )
			return _height;

		ValueExpression ve = getValueExpression("height");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setHeight(java.lang.String _height) {
		this._height = _height;
	}

	public java.lang.String getFirstPageLinkLabel() {
		if(_firstPageLinkLabel != null )
			return _firstPageLinkLabel;

		ValueExpression ve = getValueExpression("firstPageLinkLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setFirstPageLinkLabel(java.lang.String _firstPageLinkLabel) {
		this._firstPageLinkLabel = _firstPageLinkLabel;
	}

	public java.lang.String getPreviousPageLinkLabel() {
		if(_previousPageLinkLabel != null )
			return _previousPageLinkLabel;

		ValueExpression ve = getValueExpression("previousPageLinkLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setPreviousPageLinkLabel(java.lang.String _previousPageLinkLabel) {
		this._previousPageLinkLabel = _previousPageLinkLabel;
	}

	public java.lang.String getNextPageLinkLabel() {
		if(_nextPageLinkLabel != null )
			return _nextPageLinkLabel;

		ValueExpression ve = getValueExpression("nextPageLinkLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setNextPageLinkLabel(java.lang.String _nextPageLinkLabel) {
		this._nextPageLinkLabel = _nextPageLinkLabel;
	}

	public java.lang.String getLastPageLinkLabel() {
		if(_lastPageLinkLabel != null )
			return _lastPageLinkLabel;

		ValueExpression ve = getValueExpression("lastPageLinkLabel");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setLastPageLinkLabel(java.lang.String _lastPageLinkLabel) {
		this._lastPageLinkLabel = _lastPageLinkLabel;
	}

	public java.lang.String getSelectionMode() {
		if(_selectionMode != null )
			return _selectionMode;

		ValueExpression ve = getValueExpression("selectionMode");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setSelectionMode(java.lang.String _selectionMode) {
		this._selectionMode = _selectionMode;
	}

	public java.lang.Object getSelection() {
		if(_selection != null )
			return _selection;

		ValueExpression ve = getValueExpression("selection");
		return ve != null ? (java.lang.Object) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setSelection(java.lang.Object _selection) {
		this._selection = _selection;
	}

	public boolean isDynamic() {
		if(_dynamic != null )
			return _dynamic;

		ValueExpression ve = getValueExpression("dynamic");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setDynamic(boolean _dynamic) {
		this._dynamic = _dynamic;
	}

	public boolean isLazy() {
		if(_lazy != null )
			return _lazy;

		ValueExpression ve = getValueExpression("lazy");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setLazy(boolean _lazy) {
		this._lazy = _lazy;
	}

	public java.lang.String getRowIndexVar() {
		if(_rowIndexVar != null )
			return _rowIndexVar;

		ValueExpression ve = getValueExpression("rowIndexVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setRowIndexVar(java.lang.String _rowIndexVar) {
		this._rowIndexVar = _rowIndexVar;
	}

	public java.lang.String getPaginatorPosition() {
		if(_paginatorPosition != null )
			return _paginatorPosition;

		ValueExpression ve = getValueExpression("paginatorPosition");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : "both";
	}
	public void setPaginatorPosition(java.lang.String _paginatorPosition) {
		this._paginatorPosition = _paginatorPosition;
	}

	public java.lang.String getEmptyMessage() {
		if(_emptyMessage != null )
			return _emptyMessage;

		ValueExpression ve = getValueExpression("emptyMessage");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setEmptyMessage(java.lang.String _emptyMessage) {
		this._emptyMessage = _emptyMessage;
	}

	public java.lang.String getErrorMessage() {
		if(_errorMessage != null )
			return _errorMessage;

		ValueExpression ve = getValueExpression("errorMessage");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setErrorMessage(java.lang.String _errorMessage) {
		this._errorMessage = _errorMessage;
	}

	public java.lang.String getLoadingMessage() {
		if(_loadingMessage != null )
			return _loadingMessage;

		ValueExpression ve = getValueExpression("loadingMessage");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setLoadingMessage(java.lang.String _loadingMessage) {
		this._loadingMessage = _loadingMessage;
	}

	public java.lang.String getSortAscMessage() {
		if(_sortAscMessage != null )
			return _sortAscMessage;

		ValueExpression ve = getValueExpression("sortAscMessage");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setSortAscMessage(java.lang.String _sortAscMessage) {
		this._sortAscMessage = _sortAscMessage;
	}

	public java.lang.String getSortDescMessage() {
		if(_sortDescMessage != null )
			return _sortDescMessage;

		ValueExpression ve = getValueExpression("sortDescMessage");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setSortDescMessage(java.lang.String _sortDescMessage) {
		this._sortDescMessage = _sortDescMessage;
	}

	public java.lang.String getUpdate() {
		if(_update != null )
			return _update;

		ValueExpression ve = getValueExpression("update");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setUpdate(java.lang.String _update) {
		this._update = _update;
	}

	public java.lang.String getStyle() {
		if(_style != null )
			return _style;

		ValueExpression ve = getValueExpression("style");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyle(java.lang.String _style) {
		this._style = _style;
	}

	public java.lang.String getStyleClass() {
		if(_styleClass != null )
			return _styleClass;

		ValueExpression ve = getValueExpression("styleClass");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setStyleClass(java.lang.String _styleClass) {
		this._styleClass = _styleClass;
	}

	public java.lang.String getOnselectStart() {
		if(_onselectStart != null )
			return _onselectStart;

		ValueExpression ve = getValueExpression("onselectStart");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setOnselectStart(java.lang.String _onselectStart) {
		this._onselectStart = _onselectStart;
	}

	public java.lang.String getOnselectComplete() {
		if(_onselectComplete != null )
			return _onselectComplete;

		ValueExpression ve = getValueExpression("onselectComplete");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setOnselectComplete(java.lang.String _onselectComplete) {
		this._onselectComplete = _onselectComplete;
	}

	public boolean isDblClickSelect() {
		if(_dblClickSelect != null )
			return _dblClickSelect;

		ValueExpression ve = getValueExpression("dblClickSelect");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setDblClickSelect(boolean _dblClickSelect) {
		this._dblClickSelect = _dblClickSelect;
	}

	public int getPage() {
		if(_page != null )
			return _page;

		ValueExpression ve = getValueExpression("page");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 1;
	}
	public void setPage(int _page) {
		this._page = _page;
	}


	public void processDecodes(FacesContext context) {
		if(isDynamic()) {
			super.processDecodes(context);
		} else {
			int originalRows = getRows();
			setRows(getRowCount());
			super.processDecodes(context);
			setRows(originalRows);
		}
		
		//Set current page and first
		Map<String,String> params = context.getExternalContext().getRequestParameterMap();
		String currentPageParam = getClientId(context) + "_currentPage";
		if(isPaginator() && params.containsKey(currentPageParam)) {
			int currentPage = Integer.parseInt(params.get(currentPageParam));
			setPage(currentPage);
			setFirst((currentPage - 1) * getRows());
		}
    }
	
	public void processUpdates(FacesContext context) {
		super.processUpdates(context);
		
		ValueExpression selectionVE = this.getValueExpression("selection");
		if(selectionVE != null) {
			selectionVE.setValue(context.getELContext(), this._selection);
			this._selection = null;
		}
	}
	
	private String columnSelectionMode = null;
	
	public String getColumnSelectionMode() {
		if(columnSelectionMode == null) { 
			for(Iterator<javax.faces.component.UIComponent> children = getChildren().iterator(); children.hasNext();) {
				javax.faces.component.UIComponent kid = children.next();
				
				if(kid.isRendered() && kid instanceof Column) {
					Column column = (Column) kid;
					
					if(column.getSelectionMode() != null) {
						columnSelectionMode = column.getSelectionMode();
					}
				}
			}
		}
		
		return columnSelectionMode;
	}
	
	void loadLazyData() {
		DataModel model = getDataModel();
		if(model instanceof LazyDataModel) {
			LazyDataModel lazyModel = (LazyDataModel) model;
			lazyModel.setPageSize(getRows());
			lazyModel.setWrappedData(lazyModel.fetchLazyData(getFirst(), getRows()));
		}
	}
	
	private Map<String,ValueExpression> filterMap;
	
	public Map<String,ValueExpression> getFilterMap() {
		if(filterMap == null) {
			filterMap = new HashMap<String,ValueExpression>();
			
			for(Iterator<UIComponent> children = getChildren().iterator(); children.hasNext();) {
				UIComponent kid = children.next();
					
				if(kid.isRendered() && kid instanceof Column) {
					Column column = (Column) kid;
					
					if(column.getValueExpression("filterBy") != null) {
						filterMap.put(column.getClientId(FacesContext.getCurrentInstance()), column.getValueExpression("filterBy"));
					}
				}
			}
		}

		return filterMap;
	}
	
	public boolean hasFilter() {
		return getFilterMap().size() > 0;
	}
	
	public void assignDataModel(javax.faces.model.DataModel model) {
		setDataModel(model);
	}
	
	private List<Integer> selectedRowIndexes = new ArrayList<Integer>();
	
	public List<Integer> getSelectedRowIndexes() {
		return selectedRowIndexes;
	}
	
	public void setSelectedRowIndexes(List<Integer> selectedRowIndexes) {
		this.selectedRowIndexes = selectedRowIndexes;
	}
	
	public boolean isSelectionEnabled() {
		return this.getSelectionMode() != null || this.getColumnSelectionMode() != null;
	}
	
	public boolean isSingleSelectionMode() {
		return (this.getSelectionMode() != null && this.getSelectionMode().equals("single")) || (this.getColumnSelectionMode() != null && this.getColumnSelectionMode().equals("single"));
	}
	
	public String getSelectedRowIndexesAsString() {
		StringBuffer buffer = new StringBuffer();
		for(Iterator<Integer> iter = selectedRowIndexes.iterator();iter.hasNext();) {
			buffer.append(String.valueOf(iter.next()));
			
			if(iter.hasNext())
				buffer.append(",");
		}
		
		return buffer.toString();
	}

	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}

	public void encodePartially(FacesContext facesContext) throws IOException {
		Renderer renderer = getRenderer(facesContext);

		if(renderer instanceof PartialRenderer) {
			((PartialRenderer)renderer).encodePartially(facesContext, this);
		}
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[30];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _paginator;
		values[3] = _paginatorTemplate;
		values[4] = _rowsPerPageTemplate;
		values[5] = _scrollable;
		values[6] = _width;
		values[7] = _height;
		values[8] = _firstPageLinkLabel;
		values[9] = _previousPageLinkLabel;
		values[10] = _nextPageLinkLabel;
		values[11] = _lastPageLinkLabel;
		values[12] = _selectionMode;
		values[13] = _selection;
		values[14] = _dynamic;
		values[15] = _lazy;
		values[16] = _rowIndexVar;
		values[17] = _paginatorPosition;
		values[18] = _emptyMessage;
		values[19] = _errorMessage;
		values[20] = _loadingMessage;
		values[21] = _sortAscMessage;
		values[22] = _sortDescMessage;
		values[23] = _update;
		values[24] = _style;
		values[25] = _styleClass;
		values[26] = _onselectStart;
		values[27] = _onselectComplete;
		values[28] = _dblClickSelect;
		values[29] = _page;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_paginator = (java.lang.Boolean) values[2];
		_paginatorTemplate = (java.lang.String) values[3];
		_rowsPerPageTemplate = (java.lang.String) values[4];
		_scrollable = (java.lang.Boolean) values[5];
		_width = (java.lang.String) values[6];
		_height = (java.lang.String) values[7];
		_firstPageLinkLabel = (java.lang.String) values[8];
		_previousPageLinkLabel = (java.lang.String) values[9];
		_nextPageLinkLabel = (java.lang.String) values[10];
		_lastPageLinkLabel = (java.lang.String) values[11];
		_selectionMode = (java.lang.String) values[12];
		_selection = (java.lang.Object) values[13];
		_dynamic = (java.lang.Boolean) values[14];
		_lazy = (java.lang.Boolean) values[15];
		_rowIndexVar = (java.lang.String) values[16];
		_paginatorPosition = (java.lang.String) values[17];
		_emptyMessage = (java.lang.String) values[18];
		_errorMessage = (java.lang.String) values[19];
		_loadingMessage = (java.lang.String) values[20];
		_sortAscMessage = (java.lang.String) values[21];
		_sortDescMessage = (java.lang.String) values[22];
		_update = (java.lang.String) values[23];
		_style = (java.lang.String) values[24];
		_styleClass = (java.lang.String) values[25];
		_onselectStart = (java.lang.String) values[26];
		_onselectComplete = (java.lang.String) values[27];
		_dblClickSelect = (java.lang.Boolean) values[28];
		_page = (java.lang.Integer) values[29];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}