/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.touch.component.navbarcontrol;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class NavBarControlTag extends UIComponentELTag {

	private javax.el.ValueExpression _label;
	private javax.el.ValueExpression _view;
	private javax.el.ValueExpression _type;
	private javax.el.ValueExpression _effect;

	public void release(){
		super.release();
		this._label = null;
		this._view = null;
		this._type = null;
		this._effect = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.touch.component.navbarcontrol.NavBarControl component = null;
		try {
			component = (org.primefaces.touch.component.navbarcontrol.NavBarControl) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_label != null) {
			component.setValueExpression("label", _label);
		}
		if(_view != null) {
			component.setValueExpression("view", _view);
		}
		if(_type != null) {
			component.setValueExpression("type", _type);
		}
		if(_effect != null) {
			component.setValueExpression("effect", _effect);
		}
	}

	public String getComponentType() {
		return NavBarControl.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	public void setLabel(javax.el.ValueExpression expression){
		this._label = expression;
	}

	public void setView(javax.el.ValueExpression expression){
		this._view = expression;
	}

	public void setType(javax.el.ValueExpression expression){
		this._type = expression;
	}

	public void setEffect(javax.el.ValueExpression expression){
		this._effect = expression;
	}

}