/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dialog;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dialog.Dialog;
import org.primefaces.renderkit.CoreRenderer;

public class DialogRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Dialog dialog = (Dialog)component;
        this.encodeScript(facesContext, dialog);
        this.encodeMarkup(facesContext, dialog);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeScript(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dialog.getClientId(facesContext);
        String dialogVar = this.createUniqueWidgetVar(facesContext, (UIComponent)dialog);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(dialogVar + " = new PrimeFaces.widget.Dialog('" + clientId + "',");
        this.writeConfig(facesContext, dialog);
        writer.write(");\n");
        writer.write(dialogVar + ".render();\n");
        writer.write("});\n");
        writer.endElement("script");
    }

    private void writeConfig(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("{");
        writer.write("visible:" + dialog.isVisible());
        if (dialog.getWidth() != null) {
            writer.write(",width: '" + dialog.getWidth() + "'");
        }
        if (dialog.getHeight() != null) {
            writer.write(",height: '" + dialog.getHeight() + "'");
        }
        if (!dialog.isDraggable()) {
            writer.write(",draggable: false");
        }
        if (dialog.getUnderlay() != null && !dialog.getUnderlay().equalsIgnoreCase("shadow")) {
            writer.write(",underlay: '" + dialog.getUnderlay() + "'");
        }
        if (dialog.isFixedCenter()) {
            writer.write(",fixedcenter: true");
        }
        if (!dialog.isClose()) {
            writer.write(",close: false");
        }
        if (dialog.isConstrainToViewport()) {
            writer.write(",constraintoviewport: true");
        }
        if (dialog.getX() != -1) {
            writer.write(",x:" + dialog.getX());
        }
        if (dialog.getY() != -1) {
            writer.write(",y:" + dialog.getY());
        }
        if (dialog.getEffect() != null) {
            writer.write(",effect:{effect:YAHOO.widget.ContainerEffect." + dialog.getEffect().toUpperCase() + ", duration: " + dialog.getEffectDuration() + "}");
        }
        if (dialog.isModal()) {
            writer.write(",modal: true");
        }
        if (dialog.getZindex() != -1) {
            writer.write(",zIndex:" + dialog.getZindex());
        }
        if (dialog.isResizable()) {
            writer.write(",resizable:" + dialog.isResizable());
        }
        if (dialog.getMinWidth() != Integer.MIN_VALUE) {
            writer.write(",minWidth:" + dialog.getMinWidth());
        }
        if (dialog.getMinHeight() != Integer.MIN_VALUE) {
            writer.write(",minHeight:" + dialog.getMinHeight());
        }
        writer.write("}\n");
    }

    private void encodeMarkup(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dialog.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (dialog.getStyle() != null) {
            writer.writeAttribute("style", (Object)dialog.getStyle(), null);
        }
        if (dialog.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)dialog.getStyleClass(), null);
        }
        this.encodeHeader(facesContext, dialog);
        this.encodeBody(facesContext, dialog);
        this.encodeFooter(facesContext, dialog);
        writer.endElement("div");
    }

    private void encodeHeader(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent header = dialog.getFacet("header");
        UIComponent headerControls = dialog.getFacet("headerControls");
        String headerText = dialog.getHeader();
        if (header == null && headerControls == null && headerText == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"hd", null);
        if (header != null) {
            this.renderChild(facesContext, header);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        if (headerControls != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"pf-dialog-headercontrols", null);
            this.renderChild(facesContext, headerControls);
            writer.endElement("span");
        }
        writer.endElement("div");
    }

    private void encodeBody(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        if (dialog.isResizable()) {
            writer.writeAttribute("style", (Object)"overflow:auto", null);
        }
        this.renderChildren(facesContext, (UIComponent)dialog);
        writer.endElement("div");
    }

    private void encodeFooter(FacesContext facesContext, Dialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIComponent footer = dialog.getFacet("footer");
        String footerText = dialog.getFooter();
        if (footer == null && footerText == null) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ft", null);
        if (footer != null) {
            this.renderChild(facesContext, footer);
        }
        if (footerText != null) {
            writer.write(footerText);
        }
        writer.endElement("div");
    }
}

