/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dock;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dock.Dock;
import org.primefaces.component.dock.DockItem;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.resource.ResourceUtils;

public class DockRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Dock dock = (Dock)component;
        this.encodeStyle(context, dock);
        this.encodeScript(context, dock);
        this.encodeMarkup(context, dock);
    }

    private void encodeStyle(FacesContext context, Dock dock) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        responseWriter.write("<!--[if lt IE 7]>\n<style type=\"text/css\">\n");
        responseWriter.write(".pf-dock img { behavior: url('" + ResourceUtils.getResourceURL(context, "/primefaces/dock/assets/iepngfix.htc") + "');}");
        responseWriter.write("</style><![endif]-->");
    }

    private void encodeScript(FacesContext facesContext, Dock dock) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dock.getClientId(facesContext);
        String position = dock.getPosition();
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)dock);
        String containerClass = ".pf-dock-container-" + position;
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + clientId + "', function() {\n");
        writer.write(widgetVar + " = new PrimeFaces.widget.Dock('" + clientId + "', {");
        writer.write("maxWidth: " + dock.getMaxWidth());
        writer.write(",items: 'a'");
        writer.write(",itemsText: 'span'");
        writer.write(",container: '" + containerClass + "'");
        writer.write(",itemWidth: " + dock.getItemWidth());
        writer.write(",proximity: " + dock.getProximity());
        writer.write(",halign: '" + dock.getHalign() + "'");
        writer.write("});\n");
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Dock dock) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = dock.getClientId(facesContext);
        String position = dock.getPosition();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)("pf-dock-" + position), "styleClass");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("pf-dock-container-" + position), null);
        this.encodeDockItems(facesContext, dock);
        writer.endElement("div");
        writer.endElement("div");
    }

    private void encodeDockItems(FacesContext facesContext, Dock dock) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String position = dock.getPosition();
        for (UIComponent child : dock.getChildren()) {
            if (!(child instanceof DockItem) || !child.isRendered()) continue;
            DockItem dockItem = (DockItem)child;
            writer.startElement("a", null);
            writer.writeAttribute("class", (Object)("pf-dock-item-" + position), null);
            writer.writeAttribute("href", (Object)dockItem.getUrl(), "href");
            if (dockItem.getOnclick() != null) {
                writer.writeAttribute("onclick", (Object)dockItem.getOnclick(), "onclick");
            }
            if (position.equalsIgnoreCase("top")) {
                this.encodeItemIcon(facesContext, dockItem);
                this.encodeItemLabel(facesContext, dockItem);
            } else {
                this.encodeItemLabel(facesContext, dockItem);
                this.encodeItemIcon(facesContext, dockItem);
            }
            writer.endElement("a");
        }
    }

    private void encodeItemIcon(FacesContext facesContext, DockItem dockItem) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(facesContext, dockItem.getIcon()), "icon");
        writer.endElement("img");
    }

    private void encodeItemLabel(FacesContext facesContext, DockItem dockItem) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", null);
        if (dockItem.getLabel() != null) {
            writer.write(dockItem.getLabel());
        }
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

