/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterFactory;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression excludeColumns;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;

    public DataExporter() {
    }

    public DataExporter(ValueExpression target, ValueExpression type, ValueExpression fileName, ValueExpression pageOnly, ValueExpression exludeColumns, ValueExpression encoding, MethodExpression preProcessor, MethodExpression postProcessor) {
        this.target = target;
        this.type = type;
        this.fileName = fileName;
        this.pageOnly = pageOnly;
        this.excludeColumns = exludeColumns;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.encoding = encoding;
    }

    public void processAction(ActionEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        String tableId = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String encodingType = "UTF-8";
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        int[] excludedColumnIndexes = null;
        if (this.excludeColumns != null) {
            excludedColumnIndexes = this.resolveExcludedColumnIndexes((String)this.excludeColumns.getValue(elContext));
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.valueOf(this.pageOnly.getValue(facesContext.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(facesContext.getELContext());
        }
        try {
            Exporter exporter = ExporterFactory.getExporterForType(exportAs);
            UIComponent target = event.getComponent().findComponent(tableId);
            if (target == null) {
                throw new FacesException("Cannot find component \"" + tableId + "\" in view.");
            }
            if (!(target instanceof DataTable)) {
                throw new FacesException("Unsupported datasource target:\"" + target.getClass().getName() + "\", exporter must target a PrimeFaces DataTable.");
            }
            DataTable table = (DataTable)target;
            exporter.export(facesContext, table, outputFileName, isPageOnly, excludedColumnIndexes, encodingType, this.preProcessor, this.postProcessor);
            facesContext.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private int[] resolveExcludedColumnIndexes(String columnsToExclude) {
        String[] columnIndexesAsString = columnsToExclude.split(",");
        int[] indexes = new int[columnIndexesAsString.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = Integer.parseInt(columnIndexesAsString[i].trim());
        }
        return indexes;
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.pageOnly = (ValueExpression)values[3];
        this.excludeColumns = (ValueExpression)values[4];
        this.preProcessor = (MethodExpression)values[5];
        this.postProcessor = (MethodExpression)values[6];
        this.encoding = (ValueExpression)values[7];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.pageOnly, this.excludeColumns, this.preProcessor, this.postProcessor, this.encoding};
        return values;
    }
}

