/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.accordionpanel;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class AccordionPanelTag extends UIComponentELTag {

	private javax.el.ValueExpression _widgetVar;
	private javax.el.ValueExpression _activeIndex;
	private javax.el.ValueExpression _style;
	private javax.el.ValueExpression _styleClass;
	private javax.el.ValueExpression _multiple;
	private javax.el.ValueExpression _speed;
	private javax.el.ValueExpression _animate;
	private javax.el.ValueExpression _hover;
	private javax.el.ValueExpression _hoverDelay;

	public void release(){
		super.release();
		this._widgetVar = null;
		this._activeIndex = null;
		this._style = null;
		this._styleClass = null;
		this._multiple = null;
		this._speed = null;
		this._animate = null;
		this._hover = null;
		this._hoverDelay = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.accordionpanel.AccordionPanel component = null;
		try {
			component = (org.primefaces.component.accordionpanel.AccordionPanel) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_widgetVar != null) {
			component.setValueExpression("widgetVar", _widgetVar);
		}
		if(_activeIndex != null) {
			component.setValueExpression("activeIndex", _activeIndex);
		}
		if(_style != null) {
			component.setValueExpression("style", _style);
		}
		if(_styleClass != null) {
			component.setValueExpression("styleClass", _styleClass);
		}
		if(_multiple != null) {
			component.setValueExpression("multiple", _multiple);
		}
		if(_speed != null) {
			component.setValueExpression("speed", _speed);
		}
		if(_animate != null) {
			component.setValueExpression("animate", _animate);
		}
		if(_hover != null) {
			component.setValueExpression("hover", _hover);
		}
		if(_hoverDelay != null) {
			component.setValueExpression("hoverDelay", _hoverDelay);
		}
	}

	public String getComponentType() {
		return AccordionPanel.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.AccordionPanelRenderer";
	}

	public void setWidgetVar(javax.el.ValueExpression expression){
		this._widgetVar = expression;
	}

	public void setActiveIndex(javax.el.ValueExpression expression){
		this._activeIndex = expression;
	}

	public void setStyle(javax.el.ValueExpression expression){
		this._style = expression;
	}

	public void setStyleClass(javax.el.ValueExpression expression){
		this._styleClass = expression;
	}

	public void setMultiple(javax.el.ValueExpression expression){
		this._multiple = expression;
	}

	public void setSpeed(javax.el.ValueExpression expression){
		this._speed = expression;
	}

	public void setAnimate(javax.el.ValueExpression expression){
		this._animate = expression;
	}

	public void setHover(javax.el.ValueExpression expression){
		this._hover = expression;
	}

	public void setHoverDelay(javax.el.ValueExpression expression){
		this._hoverDelay = expression;
	}

}