/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.carousel;

import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.el.ValueExpression;
import javax.el.MethodExpression;
import javax.faces.render.Renderer;
import java.io.IOException;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.resource.ResourceHolder;


public class Carousel extends UIData {


	public static final String COMPONENT_TYPE = "org.primefaces.component.Carousel";
	public static final String COMPONENT_FAMILY = "org.primefaces.component";
	private static final String DEFAULT_RENDERER = "org.primefaces.component.CarouselRenderer";

	private java.lang.String _widgetVar;
	private java.lang.Integer _selectedItem;
	private java.lang.Integer _scrollIncrement;
	private java.lang.Boolean _circular;
	private java.lang.Boolean _vertical;
	private java.lang.Integer _autoPlayInterval;
	private java.lang.Integer _revealAmount;
	private java.lang.Boolean _animate;
	private java.lang.Double _speed;
	private java.lang.String _effect;
	public Carousel() {
		setRendererType(DEFAULT_RENDERER);
		ResourceHolder resourceHolder = getResourceHolder();
		if(resourceHolder != null) {
			resourceHolder.addResource("/yui/carousel/assets/skins/sam/carousel.css");
			resourceHolder.addResource("/yui/utilities/utilities.js");
			resourceHolder.addResource("/yui/carousel/carousel-min.js");
			resourceHolder.addResource("/primefaces/core/core.js");
			resourceHolder.addResource("/primefaces/carousel/carousel.js");
		}
	}

	public String getFamily() {
		return COMPONENT_FAMILY;
	}

	public java.lang.String getWidgetVar() {
		if(_widgetVar != null )
			return _widgetVar;

		ValueExpression ve = getValueExpression("widgetVar");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setWidgetVar(java.lang.String _widgetVar) {
		this._widgetVar = _widgetVar;
	}

	public int getSelectedItem() {
		if(_selectedItem != null )
			return _selectedItem;

		ValueExpression ve = getValueExpression("selectedItem");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 0;
	}
	public void setSelectedItem(int _selectedItem) {
		this._selectedItem = _selectedItem;
	}

	public int getScrollIncrement() {
		if(_scrollIncrement != null )
			return _scrollIncrement;

		ValueExpression ve = getValueExpression("scrollIncrement");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 1;
	}
	public void setScrollIncrement(int _scrollIncrement) {
		this._scrollIncrement = _scrollIncrement;
	}

	public boolean isCircular() {
		if(_circular != null )
			return _circular;

		ValueExpression ve = getValueExpression("circular");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setCircular(boolean _circular) {
		this._circular = _circular;
	}

	public boolean isVertical() {
		if(_vertical != null )
			return _vertical;

		ValueExpression ve = getValueExpression("vertical");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : false;
	}
	public void setVertical(boolean _vertical) {
		this._vertical = _vertical;
	}

	public int getAutoPlayInterval() {
		if(_autoPlayInterval != null )
			return _autoPlayInterval;

		ValueExpression ve = getValueExpression("autoPlayInterval");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 0;
	}
	public void setAutoPlayInterval(int _autoPlayInterval) {
		this._autoPlayInterval = _autoPlayInterval;
	}

	public int getRevealAmount() {
		if(_revealAmount != null )
			return _revealAmount;

		ValueExpression ve = getValueExpression("revealAmount");
		return ve != null ? (java.lang.Integer) ve.getValue(getFacesContext().getELContext())  : 0;
	}
	public void setRevealAmount(int _revealAmount) {
		this._revealAmount = _revealAmount;
	}

	public boolean isAnimate() {
		if(_animate != null )
			return _animate;

		ValueExpression ve = getValueExpression("animate");
		return ve != null ? (java.lang.Boolean) ve.getValue(getFacesContext().getELContext())  : true;
	}
	public void setAnimate(boolean _animate) {
		this._animate = _animate;
	}

	public double getSpeed() {
		if(_speed != null )
			return _speed;

		ValueExpression ve = getValueExpression("speed");
		return ve != null ? (java.lang.Double) ve.getValue(getFacesContext().getELContext())  : 0.5;
	}
	public void setSpeed(double _speed) {
		this._speed = _speed;
	}

	public java.lang.String getEffect() {
		if(_effect != null )
			return _effect;

		ValueExpression ve = getValueExpression("effect");
		return ve != null ? (java.lang.String) ve.getValue(getFacesContext().getELContext())  : null;
	}
	public void setEffect(java.lang.String _effect) {
		this._effect = _effect;
	}


	protected FacesContext getFacesContext() {
		return FacesContext.getCurrentInstance();
	}
	public Object saveState(FacesContext context) {
		Object values[] = new Object[11];
		values[0] = super.saveState(context);
		values[1] = _widgetVar;
		values[2] = _selectedItem;
		values[3] = _scrollIncrement;
		values[4] = _circular;
		values[5] = _vertical;
		values[6] = _autoPlayInterval;
		values[7] = _revealAmount;
		values[8] = _animate;
		values[9] = _speed;
		values[10] = _effect;
		return ((Object) values);
	}
	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		_widgetVar = (java.lang.String) values[1];
		_selectedItem = (java.lang.Integer) values[2];
		_scrollIncrement = (java.lang.Integer) values[3];
		_circular = (java.lang.Boolean) values[4];
		_vertical = (java.lang.Boolean) values[5];
		_autoPlayInterval = (java.lang.Integer) values[6];
		_revealAmount = (java.lang.Integer) values[7];
		_animate = (java.lang.Boolean) values[8];
		_speed = (java.lang.Double) values[9];
		_effect = (java.lang.String) values[10];
	}

	protected ResourceHolder getResourceHolder() {
		FacesContext facesContext = getFacesContext();
		if(facesContext == null)
			return null;

		ValueExpression ve = facesContext.getApplication().getExpressionFactory().createValueExpression(facesContext.getELContext(), "#{primeFacesResourceHolder}", ResourceHolder.class);

		return (ResourceHolder) ve.getValue(facesContext.getELContext());
	}
}