/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.dock;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class DockItemTag extends UIComponentELTag {

	private javax.el.ValueExpression _label;
	private javax.el.ValueExpression _onclick;
	private javax.el.ValueExpression _icon;
	private javax.el.ValueExpression _url;

	public void release(){
		super.release();
		this._label = null;
		this._onclick = null;
		this._icon = null;
		this._url = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.dock.DockItem component = null;
		try {
			component = (org.primefaces.component.dock.DockItem) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_label != null) {
			component.setValueExpression("label", _label);
		}
		if(_onclick != null) {
			component.setValueExpression("onclick", _onclick);
		}
		if(_icon != null) {
			component.setValueExpression("icon", _icon);
		}
		if(_url != null) {
			component.setValueExpression("url", _url);
		}
	}

	public String getComponentType() {
		return DockItem.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	public void setLabel(javax.el.ValueExpression expression){
		this._label = expression;
	}

	public void setOnclick(javax.el.ValueExpression expression){
		this._onclick = expression;
	}

	public void setIcon(javax.el.ValueExpression expression){
		this._icon = expression;
	}

	public void setUrl(javax.el.ValueExpression expression){
		this._url = expression;
	}

}