/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.layout;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class LayoutUnitTag extends UIComponentELTag {

	private javax.el.ValueExpression _position;
	private javax.el.ValueExpression _size;
	private javax.el.ValueExpression _minSize;
	private javax.el.ValueExpression _maxSize;
	private javax.el.ValueExpression _spacingOpen;
	private javax.el.ValueExpression _spacingClosed;
	private javax.el.ValueExpression _resizable;
	private javax.el.ValueExpression _closable;
	private javax.el.ValueExpression _slidable;
	private javax.el.ValueExpression _style;
	private javax.el.ValueExpression _styleClass;
	private javax.el.ValueExpression _closed;
	private javax.el.ValueExpression _effect;
	private javax.el.ValueExpression _effectSpeed;
	private javax.el.ValueExpression _togglerLengthOpen;
	private javax.el.ValueExpression _togglerLengthClosed;
	private javax.el.ValueExpression _togglerAlignOpen;
	private javax.el.ValueExpression _togglerAlignClosed;
	private javax.el.ValueExpression _togglerTipOpen;
	private javax.el.ValueExpression _togglerTipClosed;
	private javax.el.ValueExpression _resizerTip;

	public void release(){
		super.release();
		this._position = null;
		this._size = null;
		this._minSize = null;
		this._maxSize = null;
		this._spacingOpen = null;
		this._spacingClosed = null;
		this._resizable = null;
		this._closable = null;
		this._slidable = null;
		this._style = null;
		this._styleClass = null;
		this._closed = null;
		this._effect = null;
		this._effectSpeed = null;
		this._togglerLengthOpen = null;
		this._togglerLengthClosed = null;
		this._togglerAlignOpen = null;
		this._togglerAlignClosed = null;
		this._togglerTipOpen = null;
		this._togglerTipClosed = null;
		this._resizerTip = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.layout.LayoutUnit component = null;
		try {
			component = (org.primefaces.component.layout.LayoutUnit) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_position != null) {
			component.setValueExpression("position", _position);
		}
		if(_size != null) {
			component.setValueExpression("size", _size);
		}
		if(_minSize != null) {
			component.setValueExpression("minSize", _minSize);
		}
		if(_maxSize != null) {
			component.setValueExpression("maxSize", _maxSize);
		}
		if(_spacingOpen != null) {
			component.setValueExpression("spacingOpen", _spacingOpen);
		}
		if(_spacingClosed != null) {
			component.setValueExpression("spacingClosed", _spacingClosed);
		}
		if(_resizable != null) {
			component.setValueExpression("resizable", _resizable);
		}
		if(_closable != null) {
			component.setValueExpression("closable", _closable);
		}
		if(_slidable != null) {
			component.setValueExpression("slidable", _slidable);
		}
		if(_style != null) {
			component.setValueExpression("style", _style);
		}
		if(_styleClass != null) {
			component.setValueExpression("styleClass", _styleClass);
		}
		if(_closed != null) {
			component.setValueExpression("closed", _closed);
		}
		if(_effect != null) {
			component.setValueExpression("effect", _effect);
		}
		if(_effectSpeed != null) {
			component.setValueExpression("effectSpeed", _effectSpeed);
		}
		if(_togglerLengthOpen != null) {
			component.setValueExpression("togglerLengthOpen", _togglerLengthOpen);
		}
		if(_togglerLengthClosed != null) {
			component.setValueExpression("togglerLengthClosed", _togglerLengthClosed);
		}
		if(_togglerAlignOpen != null) {
			component.setValueExpression("togglerAlignOpen", _togglerAlignOpen);
		}
		if(_togglerAlignClosed != null) {
			component.setValueExpression("togglerAlignClosed", _togglerAlignClosed);
		}
		if(_togglerTipOpen != null) {
			component.setValueExpression("togglerTipOpen", _togglerTipOpen);
		}
		if(_togglerTipClosed != null) {
			component.setValueExpression("togglerTipClosed", _togglerTipClosed);
		}
		if(_resizerTip != null) {
			component.setValueExpression("resizerTip", _resizerTip);
		}
	}

	public String getComponentType() {
		return LayoutUnit.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return "org.primefaces.component.LayoutUnitRenderer";
	}

	public void setPosition(javax.el.ValueExpression expression){
		this._position = expression;
	}

	public void setSize(javax.el.ValueExpression expression){
		this._size = expression;
	}

	public void setMinSize(javax.el.ValueExpression expression){
		this._minSize = expression;
	}

	public void setMaxSize(javax.el.ValueExpression expression){
		this._maxSize = expression;
	}

	public void setSpacingOpen(javax.el.ValueExpression expression){
		this._spacingOpen = expression;
	}

	public void setSpacingClosed(javax.el.ValueExpression expression){
		this._spacingClosed = expression;
	}

	public void setResizable(javax.el.ValueExpression expression){
		this._resizable = expression;
	}

	public void setClosable(javax.el.ValueExpression expression){
		this._closable = expression;
	}

	public void setSlidable(javax.el.ValueExpression expression){
		this._slidable = expression;
	}

	public void setStyle(javax.el.ValueExpression expression){
		this._style = expression;
	}

	public void setStyleClass(javax.el.ValueExpression expression){
		this._styleClass = expression;
	}

	public void setClosed(javax.el.ValueExpression expression){
		this._closed = expression;
	}

	public void setEffect(javax.el.ValueExpression expression){
		this._effect = expression;
	}

	public void setEffectSpeed(javax.el.ValueExpression expression){
		this._effectSpeed = expression;
	}

	public void setTogglerLengthOpen(javax.el.ValueExpression expression){
		this._togglerLengthOpen = expression;
	}

	public void setTogglerLengthClosed(javax.el.ValueExpression expression){
		this._togglerLengthClosed = expression;
	}

	public void setTogglerAlignOpen(javax.el.ValueExpression expression){
		this._togglerAlignOpen = expression;
	}

	public void setTogglerAlignClosed(javax.el.ValueExpression expression){
		this._togglerAlignClosed = expression;
	}

	public void setTogglerTipOpen(javax.el.ValueExpression expression){
		this._togglerTipOpen = expression;
	}

	public void setTogglerTipClosed(javax.el.ValueExpression expression){
		this._togglerTipClosed = expression;
	}

	public void setResizerTip(javax.el.ValueExpression expression){
		this._resizerTip = expression;
	}

}