/*
 * Copyright 2009 Prime Technology.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.component.submenu;

import javax.faces.webapp.UIComponentELTag;
import javax.faces.component.UIComponent;

public class SubmenuTag extends UIComponentELTag {

	private javax.el.ValueExpression _label;
	private javax.el.ValueExpression _url;
	private javax.el.ValueExpression _style;
	private javax.el.ValueExpression _styleClass;
	private javax.el.ValueExpression _onclick;

	public void release(){
		super.release();
		this._label = null;
		this._url = null;
		this._style = null;
		this._styleClass = null;
		this._onclick = null;
	}

	protected void setProperties(UIComponent comp){
		super.setProperties(comp);

		org.primefaces.component.submenu.Submenu component = null;
		try {
			component = (org.primefaces.component.submenu.Submenu) comp;
		} catch(ClassCastException cce) {
			throw new IllegalStateException("Component " + component.toString() + " not expected type.");
		}

		if(_label != null) {
			component.setValueExpression("label", _label);
		}
		if(_url != null) {
			component.setValueExpression("url", _url);
		}
		if(_style != null) {
			component.setValueExpression("style", _style);
		}
		if(_styleClass != null) {
			component.setValueExpression("styleClass", _styleClass);
		}
		if(_onclick != null) {
			component.setValueExpression("onclick", _onclick);
		}
	}

	public String getComponentType() {
		return Submenu.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	public void setLabel(javax.el.ValueExpression expression){
		this._label = expression;
	}

	public void setUrl(javax.el.ValueExpression expression){
		this._url = expression;
	}

	public void setStyle(javax.el.ValueExpression expression){
		this._style = expression;
	}

	public void setStyleClass(javax.el.ValueExpression expression){
		this._styleClass = expression;
	}

	public void setOnclick(javax.el.ValueExpression expression){
		this._onclick = expression;
	}

}