/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import com.sun.facelets.FaceletsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.render.RenderKit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.primefaces.component.PartialViewRoot;
import org.primefaces.component.api.AjaxComponent;
import org.primefaces.context.RequestContext;
import org.primefaces.json.JSONException;
import org.primefaces.json.JSONObject;
import org.primefaces.util.ApplicationUtils;
import org.primefaces.util.ArrayUtils;
import org.primefaces.util.RendererUtils;

public class PrimeFacesPhaseListener
implements PhaseListener {
    private static final Logger logger = Logger.getLogger(PrimeFacesPhaseListener.class.getName());
    public static final ContextCallback RENDER_RESPONSE = new ContextCallback(){

        public void invokeContextCallback(FacesContext facesContext, UIComponent component) {
            try {
                component.encodeAll(facesContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };
    public static final ContextCallback RENDER_PARTIAL_RESPONSE = new ContextCallback(){

        public void invokeContextCallback(FacesContext facesContext, UIComponent component) {
            try {
                ((AjaxComponent)component).encodePartially(facesContext);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    };

    public void afterPhase(PhaseEvent phaseEvent) {
        RequestContext.getCurrentInstance().release();
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        boolean isPartialViewProcess;
        FacesContext facesContext = phaseEvent.getFacesContext();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        boolean isAjaxRequest = params.containsKey("primefacesPartialRequest");
        boolean bl = isPartialViewProcess = params.containsKey("primefacesPartialProcess") && !((String)params.get("primefacesPartialProcess")).equals("@all");
        if (isPartialViewProcess) {
            this.restorePartialView(facesContext);
        }
        if (isAjaxRequest) {
            this.handleAjaxRequest(facesContext);
        }
    }

    private void handleAjaxRequest(FacesContext facesContext) {
        boolean isPPRRequest;
        RequestContext requestContext = RequestContext.getCurrentInstance();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String viewNamespace = ApplicationUtils.getViewNamespace(facesContext);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Processing PrimeFaces ajax request");
        }
        this.initPartialRenderView(facesContext);
        boolean bl = isPPRRequest = !params.containsKey("primefacesPartialSource");
        if (isPPRRequest) {
            String[] idsToUpdate = this.getIdsToUpdate(facesContext, requestContext);
            ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
            response.setContentType("text/xml");
            ResponseWriter writer = facesContext.getResponseWriter();
            try {
                writer.write("<partialResponse>");
                if (idsToUpdate != null) {
                    this.writeComponents(facesContext, idsToUpdate, viewNamespace);
                }
                this.writeState(facesContext);
                if (!requestContext.getCallbackParams().isEmpty()) {
                    this.writeCallbackParams(facesContext, requestContext);
                }
                writer.write("</partialResponse>");
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        } else {
            String ajaxSource = (String)params.get("primefacesPartialSource");
            boolean found = facesContext.getViewRoot().invokeOnComponent(facesContext, ajaxSource, RENDER_PARTIAL_RESPONSE);
            if (!found) {
                logger.log(Level.WARNING, "Component \"{0}\" not found to be updated partially", ajaxSource);
            }
        }
        facesContext.responseComplete();
    }

    private String[] getIdsToUpdate(FacesContext facesContext, RequestContext requestContext) {
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String[] idsToUpdate = null;
        String declaredUpdateIds = (String)params.get("primefacesPartialUpdate");
        List<String> dynamicUpdateIds = requestContext.getPartialUpdateTargets();
        if (declaredUpdateIds != null && !declaredUpdateIds.equals("@none")) {
            idsToUpdate = declaredUpdateIds.split("[,\\s]+");
        }
        if (!dynamicUpdateIds.isEmpty()) {
            idsToUpdate = idsToUpdate != null ? ArrayUtils.concat(idsToUpdate, dynamicUpdateIds.toArray(new String[0])) : dynamicUpdateIds.toArray(new String[0]);
        }
        return idsToUpdate;
    }

    private void restorePartialView(FacesContext facesContext) {
        PartialViewRoot partialView = (PartialViewRoot)facesContext.getViewRoot();
        for (int i = 0; i < partialView.getChildCount(); ++i) {
            UIComponent kid = partialView.getChildren().get(i);
            kid.setParent(partialView.getParents().get(i));
        }
        facesContext.setViewRoot(partialView.getBase());
        partialView = null;
    }

    private void writeState(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("<state>");
        RendererUtils.startCDATA(facesContext);
        StateManager stateManager = facesContext.getApplication().getStateManager();
        stateManager.writeState(facesContext, stateManager.saveView(facesContext));
        RendererUtils.endCDATA(facesContext);
        writer.write("</state>");
    }

    private void writeComponents(FacesContext facesContext, String[] ids, String namespace) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("<components>");
        for (String id : ids) {
            String clientId = id.trim();
            if (!namespace.equals("")) {
                String viewrootClientId = facesContext.getViewRoot().getClientId(facesContext);
                clientId = viewrootClientId.indexOf(namespace) == -1 ? namespace + ":" + viewrootClientId + ":" + clientId : viewrootClientId + ":" + clientId;
            }
            writer.write("<component>");
            writer.write("<id>" + clientId + "</id>");
            writer.write("<output>");
            RendererUtils.startCDATA(facesContext);
            boolean found = facesContext.getViewRoot().invokeOnComponent(facesContext, clientId, RENDER_RESPONSE);
            if (!found) {
                logger.log(Level.WARNING, "Component \"{0}\" not found to be updated partially", clientId);
            }
            RendererUtils.endCDATA(facesContext);
            writer.write("</output>");
            writer.write("</component>");
        }
        writer.write("</components>");
    }

    private void writeCallbackParams(FacesContext facesContext, RequestContext requestContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Map<String, Object> params = requestContext.getCallbackParams();
        writer.write("<callbackParams>");
        for (String paramName : params.keySet()) {
            writer.write("<callbackParam>");
            try {
                Object paramValue = params.get(paramName);
                String json = this.isBean(paramValue) ? "{\"" + paramName + "\":" + new JSONObject(paramValue).toString() + "}" : new JSONObject().put(paramName, paramValue).toString();
                writer.write(json);
            }
            catch (JSONException e) {
                logger.log(Level.SEVERE, "Error in serializing callback parameter \"{0}\"", paramName);
                throw new FacesException(e.getMessage());
            }
            writer.write("</callbackParam>");
        }
        writer.write("</callbackParams>");
    }

    private boolean isBean(Object value) {
        if (value == null) {
            return false;
        }
        return !(value instanceof Boolean) && !(value instanceof String) && !(value instanceof Number);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    private void initPartialRenderView(FacesContext facesContext) {
        this.initPartialResponseWriter(facesContext);
        if (FaceletsUtils.isFaceletsEnabled(facesContext)) {
            try {
                FaceletsUtils.initStateWriter(facesContext);
                FaceletsUtils.buildView(facesContext);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception occured in initializing view with Facelets: {0}", e.getMessage());
                throw new FacesException((Throwable)e);
            }
        }
    }

    private void initPartialResponseWriter(FacesContext facesContext) {
        if (facesContext.getResponseWriter() != null) {
            return;
        }
        try {
            ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
            ServletRequest request = (ServletRequest)facesContext.getExternalContext().getRequest();
            response.setCharacterEncoding("UTF-8");
            RenderKit renderKit = facesContext.getRenderKit();
            ResponseWriter responseWriter = renderKit.createResponseWriter((Writer)response.getWriter(), null, request.getCharacterEncoding());
            facesContext.setResponseWriter(responseWriter);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

