/*
 * Decompiled with CFR 0.152.
 */
package jp.co.powerbeans.eclipse.plugin.prop2java;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public final class Prop2JavaChanger {
    private static final String LF = System.getProperty("line.separator");

    private Prop2JavaChanger() {
    }

    public static void exportJava(IProject project, String conf_prop, String src_path, String java_path, String charset) throws CoreException, IOException {
        IFile prop_ifile = project.getFile(String.valueOf(src_path) + "/" + conf_prop);
        File pfile = ((Path)prop_ifile.getLocation()).toFile();
        String jpath = String.valueOf(project.getLocation().toString()) + "/" + src_path + "/" + java_path.replace('.', '/');
        if (!jpath.endsWith(".java")) {
            jpath = String.valueOf(jpath) + ".java";
        }
        File jfile = new File(jpath);
        jfile.getParentFile().mkdir();
        jfile.createNewFile();
        Prop2JavaChanger.export(pfile, jfile, conf_prop, java_path, charset);
    }

    private static void export(File pfile, File jfile, String prop_path, String java_path, String charset) throws IOException {
        String bundle;
        PropertyResourceBundle rb = new PropertyResourceBundle(new FileInputStream(pfile));
        OutputStreamWriter fw = null;
        fw = charset == null || charset.length() == 0 ? new OutputStreamWriter(new FileOutputStream(jfile)) : new OutputStreamWriter((OutputStream)new FileOutputStream(jfile), charset);
        String class_name = jfile.getName().split("\\.")[0];
        String package_name = "";
        if (java_path.indexOf(".") != -1) {
            package_name = java_path.substring(0, java_path.lastIndexOf("."));
        }
        if ((bundle = prop_path).endsWith(".properties")) {
            bundle = bundle.substring(0, bundle.length() - ".properties".length());
        }
        String class_bundle = bundle.replace('/', '.');
        if (package_name.length() > 0) {
            fw.write("package " + package_name + ";" + LF);
        }
        fw.write(LF);
        fw.write("/**" + LF);
        fw.write(" * Const class by " + bundle + "." + LF);
        fw.write(" */" + LF);
        fw.write("public final class " + class_name + " {" + LF);
        fw.write(LF);
        fw.write("  static java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle(\"" + class_bundle + "\");" + LF);
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String val = rb.getString(key);
            String method = Prop2JavaChanger.createMethod(key);
            fw.write(LF);
            fw.write("  /**" + LF);
            fw.write("   * return value of " + key + " in " + bundle + "." + LF);
            fw.write("   * @return \"" + val + "\"" + LF);
            fw.write("   */" + LF);
            fw.write("  public static final String get" + method + "() {" + LF);
            fw.write("    return bundle.getString(\"" + key + "\");" + LF);
            fw.write("  }" + LF);
        }
        fw.write(LF);
        fw.write("  /**" + LF);
        fw.write("   * return value of key in " + bundle + "." + LF);
        fw.write("   * @return value of key" + LF);
        fw.write("   */" + LF);
        fw.write("  public static final String get(final String key) {" + LF);
        fw.write("    return bundle.getString(key);" + LF);
        fw.write("  }" + LF);
        fw.write("}" + LF);
        fw.close();
    }

    private static String createMethod(String key) {
        CharArrayWriter caw = new CharArrayWriter();
        boolean big = false;
        int i = 0;
        while (i < key.length()) {
            char c = key.charAt(i);
            if (c == '.') {
                big = true;
            } else {
                char out_c = i == 0 || big ? Character.toUpperCase(c) : c;
                caw.write(out_c);
                big = false;
            }
            ++i;
        }
        return caw.toString();
    }
}

