/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors;

import java.util.Iterator;
import java.util.ResourceBundle;
import jp.sf.propdev.PropDevMessages;
import jp.sf.propdev.actions.ContentFormatAction;
import jp.sf.propdev.actions.InformationAction;
import jp.sf.propdev.actions.NextKeyAction;
import jp.sf.propdev.actions.PreviousKeyAction;
import jp.sf.propdev.editors.EditorSelectionChangedListener;
import jp.sf.propdev.editors.PropertiesConfiguration;
import jp.sf.propdev.editors.text.PropertiesTextFileDocumentProvider;
import jp.sf.propdev.model.AbstractNode;
import jp.sf.propdev.model.IPropertiesModelListener;
import jp.sf.propdev.model.PropertiesModelChangeEvent;
import jp.sf.propdev.model.PropertiesNode;
import jp.sf.propdev.outline.PropertiesContentOutlinePage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertiesEditor
extends TextEditor
implements IPropertiesModelListener {
    public static String EDITOR_ID = "jp.sf.propdev.editors.PropertiesEditor";
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    private PropertiesContentOutlinePage fOutlinePage;
    private ProjectionSupport fProjectionSupport;
    protected ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PropertiesEditor.this.doSelectionChanged(event);
        }
    };
    PropertiesNode propertiesModel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertiesEditor() {
        this.setDocumentProvider(this.createDocumentProvider());
        this.propertiesModel = this.touchPropertiesModel();
        this.setSourceViewerConfiguration(new PropertiesConfiguration(this.propertiesModel));
    }

    protected IDocumentProvider createDocumentProvider() {
        return new PropertiesTextFileDocumentProvider();
    }

    protected void adjustHighlightRange(int offset, int length) {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.fProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.install();
        viewer.doOperation(19);
        this.getOutlinePage();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void dispose() {
        if (this.fOutlinePage != null) {
            this.fOutlinePage.setInput(null);
            this.propertiesModel.removeAntModelListener(this.fOutlinePage);
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        this.propertiesModel.removeAntModelListener(this);
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
        if (this.fOutlinePage != null) {
            this.fOutlinePage.update();
        }
    }

    void doSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else {
            AbstractNode segment = (AbstractNode)selection.getFirstElement();
            int start = segment.getStartOffset();
            int length = segment.getEndOffset() - start;
            try {
                this.setHighlightRange(start, length, !this.isActivePart());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.resetHighlightRange();
            }
        }
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
    }

    protected void editorContextMenuAboutToShow(IMenuManager parentMenu) {
        super.editorContextMenuAboutToShow(parentMenu);
        ResourceBundle rb = PropDevMessages.getResourceBundle();
        parentMenu.add((IContributionItem)new Separator());
        PreviousKeyAction pka = new PreviousKeyAction(rb, "GotoPreviousKeyLine.", (ITextEditor)this);
        parentMenu.add((IAction)pka);
        NextKeyAction nka = new NextKeyAction(rb, "GotoNextKeyLine.", (ITextEditor)this);
        parentMenu.add((IAction)nka);
        ContentFormatAction cfa = new ContentFormatAction(rb, "ContentFormat.", (ITextEditor)this);
        parentMenu.add((IAction)cfa);
        parentMenu.add((IContributionItem)new Separator());
        InformationAction ia = new InformationAction(rb, "Information.", (ITextEditor)this);
        parentMenu.add((IAction)ia);
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return service.getActivePart();
    }

    public Object getAdapter(Class required) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getOutlinePage();
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    private IAnnotationModel getAnnotationModel() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IAnnotationModel)this.getAdapter(clazz);
    }

    private PropertiesContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new PropertiesContentOutlinePage(this.getDocumentProvider(), this);
            this.propertiesModel.addAntModelListener(this.fOutlinePage);
            this.fOutlinePage.addSelectionChangedListener(this.fSelectionChangedListener);
            this.fEditorSelectionChangedListener = new EditorSelectionChangedListener(this.propertiesModel, this.fOutlinePage);
            this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
            if (this.getEditorInput() != null) {
                this.fOutlinePage.setInput(this.propertiesModel);
            }
        }
        return this.fOutlinePage;
    }

    public PropertiesNode getPropertiesModel() {
        return this.propertiesModel;
    }

    protected PropertiesNode touchPropertiesModel() {
        if (this.getDocumentProvider() instanceof TextFileDocumentProvider) {
            return ((PropertiesTextFileDocumentProvider)this.getDocumentProvider()).getPropertiesModel(this.getEditorInput());
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.propertiesModel.addAntModelListener(this);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ui.textEditorScope", "jp.sf.propdev.ui.editor.scope"});
    }

    private boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    public void updateDefineFoldingRegion(PropertiesNode propertiesModel) {
        IAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            Iterator ite = propertiesModel.getOutlineModel().iterator();
            while (ite.hasNext()) {
                AbstractNode an = (AbstractNode)ite.next();
                if (!an.isMultiLine()) continue;
                Position position = new Position(an.getStartOffset(), an.getLength());
                model.addAnnotation((Annotation)new ProjectionAnnotation(), position);
            }
        }
    }

    public void propertiesModelChanged(PropertiesModelChangeEvent event) {
        this.updateDefineFoldingRegion(event.getModel());
    }
}

