/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class PropertiesTextHover
implements ITextHover {
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document = textViewer.getDocument();
        int offset = hoverRegion.getOffset();
        int length = hoverRegion.getLength();
        try {
            String text = document.get(offset, length);
            return text;
        }
        catch (BadLocationException badLocationException) {
            return "BadLocationException";
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer != null) {
            return PropertiesTextHover.getRegion(textViewer, offset);
        }
        return null;
    }

    public static IRegion getRegion(ITextViewer textViewer, int offset) {
        IDocument document = textViewer.getDocument();
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (c != '.' && c != '-' && c != '/' && c != '\\' && !Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (c != '.' && c != '-' && !Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }
}

