/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.propdev.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import jp.sf.propdev.PropDevMessages;
import jp.sf.propdev.editors.text.IProblem;
import jp.sf.propdev.editors.text.IProblemRequestor;
import jp.sf.propdev.editors.text.LocationProvider;
import jp.sf.propdev.editors.text.PropertiesProblem;
import jp.sf.propdev.model.AbstractNode;
import jp.sf.propdev.model.CommentNode;
import jp.sf.propdev.model.IPropertiesModelListener;
import jp.sf.propdev.model.KeyNode;
import jp.sf.propdev.model.PropertiesEditorMarkerUpdater;
import jp.sf.propdev.model.PropertiesModelChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class PropertiesNode
extends AbstractNode {
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String whiteSpaceChars = " \t\r\n\f";
    IDocumentListener docListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            PropertiesNode.this.documentDirty = true;
        }
    };
    protected boolean documentDirty;
    private IDocument fDocument;
    private String[] fKeys;
    private LocationProvider fLocationProvider;
    private PropertiesEditorMarkerUpdater fMarkerUpdater;
    private List fModelChangeListeners = new ArrayList();
    private IProblemRequestor fProblemRequestor;
    private Stack outlineModel = new Stack();

    private static boolean continueLine(String line) {
        int slashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++slashCount;
        }
        return slashCount % 2 == 1;
    }

    private static String getLineString(IDocument document, int lineIndex) throws BadLocationException {
        int offset = document.getLineOffset(lineIndex);
        int length = document.getLineLength(lineIndex);
        String line = document.get(offset, length).trim();
        return line;
    }

    private static int getStartPos(String line) {
        int len = line.length();
        int keyStart = 0;
        while (keyStart < len) {
            if (whiteSpaceChars.indexOf(line.charAt(keyStart)) == -1) break;
            ++keyStart;
        }
        return keyStart;
    }

    private static String loadConvert(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    public PropertiesNode(IDocument document) {
        super(null);
        this.fDocument = document;
        this.fDocument.addDocumentListener(this.docListener);
        this.reload();
    }

    public PropertiesNode(IDocument document, IProblemRequestor problemRequestor, LocationProvider locationProvider) {
        super(null);
        this.fDocument = document;
        this.fDocument.addDocumentListener(this.docListener);
        this.fLocationProvider = locationProvider;
        this.fProblemRequestor = problemRequestor;
        this.fMarkerUpdater = new PropertiesEditorMarkerUpdater(this.getFile());
        this.reload();
    }

    public void acceptProblem(IProblem problem) {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.acceptProblem(problem);
            this.fMarkerUpdater.acceptProblem(problem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAntModelListener(IPropertiesModelListener listener) {
        List list = this.fModelChangeListeners;
        synchronized (list) {
            this.fModelChangeListeners.add(listener);
        }
    }

    private void beginReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.beginReporting();
            this.fMarkerUpdater.beginReporting();
        }
    }

    private void checkOverLapKey(List outline) {
        if (this.fProblemRequestor == null) {
            return;
        }
        String overlapMessage = PropDevMessages.getString("AnnotationHover.overlapMark");
        int length = outline.size();
        int i = length - 1;
        while (i > 0) {
            Object obj1 = outline.get(i);
            if (obj1 instanceof KeyNode) {
                KeyNode keyNode1 = (KeyNode)obj1;
                int j = i - 1;
                while (j >= 0) {
                    Object obj2 = outline.get(j);
                    if (obj2 instanceof KeyNode && keyNode1.getKey().equals(((KeyNode)obj2).getKey())) {
                        String message = MessageFormat.format(overlapMessage, Integer.toString(this.getLine(((KeyNode)obj2).getStartOffset())), Integer.toString(this.getLine(keyNode1.getStartOffset())));
                        IProblem problem = this.createProblem(message, keyNode1.getStartOffset(), keyNode1.getLength(), 1);
                        this.acceptProblem(problem);
                    }
                    --j;
                }
            }
            --i;
        }
    }

    private IProblem createProblem(String message, int offset, int length, int severity) {
        return new PropertiesProblem(message, severity, offset, length, this.getLine(offset));
    }

    public void dispose() {
        this.fDocument.removeDocumentListener(this.docListener);
    }

    private void endReporting() {
        if (this.fProblemRequestor != null) {
            this.fProblemRequestor.endReporting();
        }
    }

    protected IFile getFile() {
        IPath location = this.fLocationProvider.getLocation();
        if (location == null) {
            return null;
        }
        IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(location);
        if (files.length > 0) {
            return files[0];
        }
        return null;
    }

    public String[] getKeys() {
        if (this.fKeys != null) {
            return this.fKeys;
        }
        List outline = this.getOutlineModel();
        TreeSet<String> keySet = new TreeSet<String>();
        Iterator iterator = outline.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof KeyNode)) continue;
            KeyNode keyNode = (KeyNode)obj;
            keySet.add(keyNode.getKey().toLowerCase());
        }
        this.fKeys = new String[keySet.size()];
        return keySet.toArray(this.fKeys);
    }

    private int getLine(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public List getOutlineModel() {
        return this.outlineModel;
    }

    public void install() {
    }

    public boolean isDocumentDirty() {
        return this.documentDirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void notifyAntModelListeners(PropertiesModelChangeEvent event) {
        var3_2 = this.fModelChangeListeners;
        synchronized (var3_2) {
            i = new ArrayList<E>(this.fModelChangeListeners).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var3_2
            if (true) ** GOTO lbl11
        }
        do {
            ((IPropertiesModelListener)i.next()).propertiesModelChanged(event);
lbl11:
            // 2 sources

        } while (i.hasNext());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertiesNode reload() {
        this.outlineModel.clear();
        this.fKeys = null;
        try {
            this.setStartOffset(0);
            this.addLength(this.fDocument.getLength());
            int lines = this.fDocument.getNumberOfLines();
            int lineIndex = 0;
            while (lineIndex < lines) {
                String line = PropertiesNode.getLineString(this.fDocument, lineIndex);
                if (line == null) {
                    line = "";
                }
                int len = line.length();
                int keyStart = PropertiesNode.getStartPos(line);
                if (keyStart != len) {
                    char firstChar = line.charAt(keyStart);
                    if (firstChar == '#' || firstChar == '!') {
                        CommentNode cn;
                        if (this.outlineModel.size() == 0) {
                            cn = new CommentNode(this);
                            cn.setStartLine(lineIndex);
                            this.outlineModel.push(cn);
                        } else if (!(this.outlineModel.peek() instanceof CommentNode)) {
                            cn = new CommentNode(this);
                            cn.setStartOffset(this.fDocument.getLineOffset(lineIndex));
                            cn.setStartLine(lineIndex);
                            this.outlineModel.push(cn);
                        }
                        cn = (CommentNode)this.outlineModel.peek();
                        cn.addLength(this.fDocument.getLineLength(lineIndex));
                        cn.setEndLine(lineIndex);
                    } else {
                        int separatorIndex;
                        KeyNode kn = new KeyNode(this);
                        kn.setStartOffset(this.fDocument.getLineOffset(lineIndex));
                        kn.setStartLine(lineIndex);
                        kn.addLength(this.fDocument.getLineLength(lineIndex));
                        while (true) {
                            String nextLine;
                            if (!PropertiesNode.continueLine(line)) {
                                kn.setEndLine(lineIndex);
                                separatorIndex = keyStart;
                                break;
                            }
                            if ((nextLine = PropertiesNode.getLineString(this.fDocument, ++lineIndex)) == null) {
                                nextLine = "";
                            }
                            String loppedLine = line.substring(0, len - 1);
                            int startIndex = 0;
                            while (startIndex < nextLine.length() && whiteSpaceChars.indexOf(nextLine.charAt(startIndex)) != -1) {
                                ++startIndex;
                            }
                            nextLine = nextLine.substring(startIndex, nextLine.length());
                            line = new String(String.valueOf(loppedLine) + nextLine);
                            len = line.length();
                            kn.addLength(this.fDocument.getLineLength(lineIndex));
                        }
                        while (separatorIndex < len) {
                            char currentChar = line.charAt(separatorIndex);
                            if (currentChar == '\\') {
                                ++separatorIndex;
                            } else if (keyValueSeparators.indexOf(currentChar) != -1) break;
                            ++separatorIndex;
                        }
                        int valueIndex = separatorIndex;
                        while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                            ++valueIndex;
                        }
                        if (valueIndex < len && strictKeyValueSeparators.indexOf(line.charAt(valueIndex)) != -1) {
                            ++valueIndex;
                        }
                        while (valueIndex < len && whiteSpaceChars.indexOf(line.charAt(valueIndex)) != -1) {
                            ++valueIndex;
                        }
                        String key = line.substring(keyStart, separatorIndex);
                        key = PropertiesNode.loadConvert(key);
                        kn.setKey(key);
                        this.outlineModel.push(kn);
                    }
                }
                ++lineIndex;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.setDocumentDirty(true);
        try {
            this.beginReporting();
            this.checkOverLapKey(this.outlineModel);
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.endReporting();
            throw throwable;
        }
        {
            Object var1_4 = null;
            this.endReporting();
            this.notifyAntModelListeners(new PropertiesModelChangeEvent(this));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAntModelListener(IPropertiesModelListener listener) {
        List list = this.fModelChangeListeners;
        synchronized (list) {
            this.fModelChangeListeners.remove(listener);
        }
    }

    public void setDocumentDirty(boolean documentDirty) {
        this.documentDirty = documentDirty;
    }

    public void updateForInitialReconcile() {
        this.fMarkerUpdater.updateMarkers();
    }

    public void updateMarkers() {
        this.reload();
        this.fMarkerUpdater.updateMarkers();
    }
}

