/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.preference;

import java.io.UnsupportedEncodingException;
import jp.gr.java_conf.ussiy.app.propedit.PropertiesEditor;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.MultiPagePropertiesEditor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class PropertiesEditorPreference
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_CHECK_KEY = "checkKeyPreference";
    public static final String P_ENCODE = "readEncode";
    public static final String P_FONT = "fontPreference";
    public static final String P_NOT_CONVERT_COMMENT = "notConvertComment";
    private Combo encodeCombo;

    public PropertiesEditorPreference() {
        super(1);
        this.setPreferenceStore(PropertiesEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(PropertiesEditor.res.getString("eclipse.propertieseditor.preference.page.title"));
        this.initializeDefaults();
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        Composite composite2 = null;
        if (control instanceof Composite) {
            composite2 = (Composite)control;
        }
        if (composite2 == null) {
            return control;
        }
        Label label = new Label(composite2, 0);
        label.setText(PropertiesEditor.res.getString("eclipse.propertieseditor.preference.read.encode"));
        this.encodeCombo = new Combo(composite2, 0);
        this.encodeCombo.setItems(new String[]{System.getProperty("file.encoding"), "US-ASCII", "UTF-8", "UTF-16"});
        this.encodeCombo.setText(this.getPreferenceStore().getString(P_ENCODE));
        return composite2;
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new FontFieldEditor(P_FONT, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.font"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_CHECK_KEY, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.checkduplication"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_NOT_CONVERT_COMMENT, "&" + PropertiesEditor.res.getString("eclipse.propertieseditor.preference.convert.comment"), this.getFieldEditorParent()));
    }

    public void init(IWorkbench iWorkbench) {
    }

    private void initializeDefaults() {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.encodeCombo.setText(System.getProperty("file.encoding"));
    }

    public boolean performOk() {
        boolean bl = true;
        try {
            if (!this.encodeCombo.getText().equals("")) {
                new String(this.toString().getBytes(), this.encodeCombo.getText());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            PropertiesEditorPlugin propertiesEditorPlugin = PropertiesEditorPlugin.getDefault();
            String string = propertiesEditorPlugin.getDescriptor().getUniqueIdentifier();
            Status status = new Status(4, string, -1, unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"The encoding is not supported.", (IStatus)status);
            return false;
        }
        this.getPreferenceStore().setValue(P_ENCODE, this.encodeCombo.getText());
        bl = super.performOk();
        this.setFontToEditor();
        return bl;
    }

    private void setFontToEditor() {
        Font font = new Font((Device)Display.getCurrent(), PreferenceConverter.getFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)P_FONT));
        IWorkbenchWindow[] iWorkbenchWindowArray = PropertiesEditorPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        int n = 0;
        while (n < iWorkbenchWindowArray.length) {
            IWorkbenchPage[] iWorkbenchPageArray = iWorkbenchWindowArray[n].getPages();
            int n2 = 0;
            while (n2 < iWorkbenchPageArray.length) {
                IEditorReference[] iEditorReferenceArray = iWorkbenchPageArray[n2].getEditorReferences();
                int n3 = 0;
                while (n3 < iEditorReferenceArray.length) {
                    IEditorReference iEditorReference = iEditorReferenceArray[n3];
                    IEditorPart iEditorPart = iEditorReference.getEditor(false);
                    if (iEditorPart instanceof MultiPagePropertiesEditor) {
                        ((MultiPagePropertiesEditor)iEditorPart).getEditor().setFont(font);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
    }
}

