/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jp.gr.java_conf.ussiy.app.propedit.BaseDialog;
import jp.gr.java_conf.ussiy.swing.JExtendedPopupComboBox;

public class JFontChooserDialog
extends BaseDialog {
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int ERROR_OPTION = -1;
    private JLabel backgroundColorLabel;
    private Border border1;
    private BorderLayout borderLayout1;
    private BorderLayout borderLayout2;
    private BorderLayout borderLayout3;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JLabel charaColorLabel;
    private static Color defaultBackgroundColor;
    private static Font defaultFont;
    private static Color defaultForegroundColor;
    private FlowLayout flowLayout1;
    private JComboBox fontNameComboBox;
    private String[] fontNameList;
    private static final String[] fontSizeList;
    private static final int[] fontStyleCodeList;
    private GridBagLayout gridBagLayout1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel panel1 = new JPanel();
    static ResourceBundle res;
    private int returnValue = -1;
    JTextField sampleTextField;
    private JButton selectBackgroundButton;
    private JButton selectForegroundButton;
    private JButton setButton;
    private JComboBox sizeComboBox;
    private JComboBox styleComboBox;
    private TitledBorder titledBorder1;

    static {
        res = ResourceBundle.getBundle("lang");
        defaultFont = new Font("Dialog", 0, 10);
        defaultForegroundColor = Color.BLACK;
        defaultBackgroundColor = Color.WHITE;
        fontSizeList = new String[]{"7", "8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
        fontStyleCodeList = new int[]{0, 1, 2, 3};
    }

    public JFontChooserDialog(Frame frame, Font font, Color color, Color color2, boolean bl) {
        super(frame, res.getString("fontchooser_title"), bl);
        this.borderLayout1 = new BorderLayout();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.borderLayout2 = new BorderLayout();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jLabel1 = new JLabel();
        this.fontNameComboBox = new JExtendedPopupComboBox();
        this.jLabel2 = new JLabel();
        this.styleComboBox = new JExtendedPopupComboBox();
        this.jLabel3 = new JLabel();
        this.sizeComboBox = new JExtendedPopupComboBox();
        this.charaColorLabel = new JLabel();
        this.selectForegroundButton = new JButton();
        this.jPanel5 = new JPanel();
        this.gridBagLayout1 = new GridBagLayout();
        this.borderLayout3 = new BorderLayout();
        this.backgroundColorLabel = new JLabel();
        this.selectBackgroundButton = new JButton();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.setButton = new JButton();
        this.flowLayout1 = new FlowLayout();
        this.sampleTextField = new JTextField();
        defaultFont = font;
        defaultForegroundColor = color;
        defaultBackgroundColor = color2;
        try {
            this.jbInit();
            this.initialize();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JFontChooserDialog(Frame frame, boolean bl) {
        this(frame, defaultFont, defaultForegroundColor, defaultBackgroundColor, bl);
    }

    private void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.returnValue = 1;
        this.dispose();
    }

    private void fontNameComboBox_actionPerformed(ActionEvent actionEvent) {
        Font font = this.sampleTextField.getFont();
        Font font2 = new Font((String)this.fontNameComboBox.getSelectedItem(), font.getStyle(), font.getSize());
        this.sampleTextField.setFont(font2);
    }

    public Color getBackgroundColor() {
        return defaultBackgroundColor;
    }

    private int getFontStyleCodeByFontStyleString(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("Plain")) {
            return 0;
        }
        if (string.equals("Bold")) {
            return 1;
        }
        if (string.equals("Italic")) {
            return 2;
        }
        if (string.equals("Bold Italic")) {
            return 3;
        }
        return -1;
    }

    private String getFontStyleStringByFontStyleCode(int n) {
        switch (n) {
            case 0: {
                return "Plain";
            }
            case 1: {
                return "Bold";
            }
            case 2: {
                return "Italic";
            }
            case 3: {
                return "Bold Italic";
            }
        }
        return null;
    }

    public Color getForgroundColor() {
        return defaultForegroundColor;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public Font getSelectedFont() {
        String string = (String)this.fontNameComboBox.getSelectedItem();
        int n = this.getFontStyleCodeByFontStyleString((String)this.styleComboBox.getSelectedItem());
        int n2 = Integer.parseInt((String)this.sizeComboBox.getSelectedItem());
        return new Font(string, n, n2);
    }

    private void initialize() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontNameList = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = 0;
        while (n < this.fontNameList.length) {
            this.fontNameComboBox.addItem(this.fontNameList[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < fontStyleCodeList.length) {
            this.styleComboBox.addItem(this.getFontStyleStringByFontStyleCode(fontStyleCodeList[n2]));
            ++n2;
        }
        int n3 = 0;
        while (n3 < fontSizeList.length) {
            this.sizeComboBox.addItem(fontSizeList[n3]);
            ++n3;
        }
        this.fontNameComboBox.setSelectedItem(defaultFont.getFamily());
        this.styleComboBox.setSelectedItem(this.getFontStyleStringByFontStyleCode(defaultFont.getStyle()));
        this.sizeComboBox.setSelectedItem(Integer.toString(defaultFont.getSize()));
        this.sampleTextField.setFont(defaultFont);
        this.sampleTextField.setForeground(defaultForegroundColor);
        this.sampleTextField.setBackground(defaultBackgroundColor);
        this.backgroundColorLabel.setBackground(defaultBackgroundColor);
        this.charaColorLabel.setForeground(defaultForegroundColor);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.titledBorder1 = new TitledBorder(this.border1, res.getString("sample_titled_border"));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jLabel1.setText(res.getString("font_name"));
        this.jLabel2.setText(res.getString("style_name"));
        this.jLabel3.setText(res.getString("font_size"));
        this.charaColorLabel.setOpaque(true);
        this.charaColorLabel.setPreferredSize(new Dimension(50, 26));
        this.charaColorLabel.setHorizontalAlignment(0);
        this.charaColorLabel.setText(res.getString("font_color"));
        this.selectForegroundButton.setText(res.getString("selectForegroundButton_text"));
        this.selectForegroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.selectForegroundButton_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel5.setBorder(this.titledBorder1);
        this.jPanel5.setLayout(this.borderLayout3);
        this.sampleTextField.setText(res.getString("sample_character"));
        this.panel1.setMinimumSize(new Dimension(300, 200));
        this.jPanel1.setPreferredSize(new Dimension(300, 120));
        this.fontNameComboBox.setPreferredSize(new Dimension(100, 18));
        this.fontNameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.fontNameComboBox_actionPerformed(actionEvent);
            }
        });
        this.styleComboBox.setMinimumSize(new Dimension(23, 18));
        this.styleComboBox.setPreferredSize(new Dimension(70, 18));
        this.styleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.styleComboBox_actionPerformed(actionEvent);
            }
        });
        this.sizeComboBox.setMinimumSize(new Dimension(23, 18));
        this.sizeComboBox.setPreferredSize(new Dimension(50, 18));
        this.sizeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.sizeComboBox_actionPerformed(actionEvent);
            }
        });
        this.backgroundColorLabel.setOpaque(true);
        this.backgroundColorLabel.setPreferredSize(new Dimension(50, 26));
        this.backgroundColorLabel.setHorizontalAlignment(0);
        this.backgroundColorLabel.setHorizontalTextPosition(11);
        this.backgroundColorLabel.setText(res.getString("backgroundColorLabel_bgcolor"));
        this.selectBackgroundButton.setText(res.getString("selectBackgroundButton_text"));
        this.selectBackgroundButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.selectBackgroundButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setText(res.getString("cancelButton_text"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.setButton.setText(res.getString("setButton_text"));
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFontChooserDialog.this.setButton_actionPerformed(actionEvent);
            }
        });
        this.buttonPanel.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(5);
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel3.setBorder(null);
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanel5, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 4, 4), 390, 219));
        this.jPanel5.add((Component)this.sampleTextField, "Center");
        this.panel1.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.charaColorLabel, null);
        this.jPanel3.add((Component)this.selectForegroundButton, null);
        this.jPanel3.add((Component)this.backgroundColorLabel, null);
        this.jPanel3.add((Component)this.selectBackgroundButton, null);
        this.jPanel2.add((Component)this.jPanel4, "North");
        this.jPanel4.add((Component)this.jLabel1, null);
        this.jPanel4.add((Component)this.fontNameComboBox, null);
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.styleComboBox, null);
        this.jPanel4.add((Component)this.jLabel3, null);
        this.jPanel4.add((Component)this.sizeComboBox, null);
        this.panel1.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.setButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
    }

    private void selectBackgroundButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, res.getString("colorchooser_title"), defaultBackgroundColor);
        if (color == null) {
            return;
        }
        defaultBackgroundColor = color;
        this.backgroundColorLabel.setBackground(defaultBackgroundColor);
        this.sampleTextField.setBackground(defaultBackgroundColor);
    }

    private void selectForegroundButton_actionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(this, res.getString("colorchooser_title"), defaultForegroundColor);
        if (color == null) {
            return;
        }
        defaultForegroundColor = color;
        this.charaColorLabel.setForeground(defaultForegroundColor);
        this.sampleTextField.setForeground(defaultForegroundColor);
    }

    private void setButton_actionPerformed(ActionEvent actionEvent) {
        this.returnValue = 0;
        this.dispose();
    }

    private void sizeComboBox_actionPerformed(ActionEvent actionEvent) {
        Font font = this.sampleTextField.getFont();
        Font font2 = new Font(font.getFontName(), font.getStyle(), Integer.parseInt((String)this.sizeComboBox.getSelectedItem()));
        this.sampleTextField.setFont(font2);
    }

    private void styleComboBox_actionPerformed(ActionEvent actionEvent) {
        Font font = this.sampleTextField.getFont();
        Font font2 = new Font(font.getFontName(), this.getFontStyleCodeByFontStyleString((String)this.styleComboBox.getSelectedItem()), font.getSize());
        this.sampleTextField.setFont(font2);
    }
}

