/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text;

import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.search.internal.ui.text.FileSearchResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;

public class SearchResultUpdater
implements IResourceChangeListener,
IQueryListener {
    FileSearchResult fResult;

    public SearchResultUpdater(FileSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void handleDelta(IResourceDelta delta) {
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    switch (delta.getKind()) {
                        case 1: {
                            return false;
                        }
                        case 2: {
                            IResource res = delta.getResource();
                            if (!(res instanceof IFile)) break;
                            Match[] matches = SearchResultUpdater.this.fResult.getMatches(res);
                            SearchResultUpdater.this.fResult.removeMatches(matches);
                            break;
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            SearchPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (((Object)((Object)this.fResult)).equals(query.getSearchResult())) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.handleDelta(delta);
        }
    }
}

