/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.PropertiesEditorPlugin;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.listener.IPropertiesDocumentListener;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    private static final String EXTENSION_POINT = "jp.gr.java_conf.ussiy.app.propedit.listeners";

    protected List computePropertiesDocumentListeners() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> results = new ArrayList<Object>();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                try {
                    Object listener = elements[j].createExecutableExtension("class");
                    if (!(listener instanceof IPropertiesDocumentListener)) continue;
                    results.add(listener);
                    continue;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return results;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IPropertiesDocumentListener listener;
        int i;
        String readEncode = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
        if (readEncode == null || readEncode.equals("")) {
            readEncode = this.getDefaultEncoding();
        }
        IDocument document = null;
        if (element instanceof IEditorInput && !this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element, readEncode)) {
            document = null;
        }
        List listeners = this.computePropertiesDocumentListeners();
        for (i = 0; i < listeners.size(); ++i) {
            listener = (IPropertiesDocumentListener)listeners.get(i);
            try {
                listener.beforeConvertAtLoadingDocument(document.get(), element);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (document != null) {
            document.set(EncodeChanger.unicodeEsc2Unicode(document.get()));
            for (i = 0; i < listeners.size(); ++i) {
                listener = (IPropertiesDocumentListener)listeners.get(i);
                try {
                    listener.afterConvertAtLoadingDocument(document.get(), element);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__dftl_partition_content_type", "__properties_comment", "__properties_separator", "__properties_value"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                String encoding = PropertiesEditorPlugin.getDefault().getPreferenceStore().getString("readEncode");
                if (encoding == null || encoding.equals("")) {
                    encoding = this.getDefaultEncoding();
                }
                List listeners = this.computePropertiesDocumentListeners();
                for (int i = 0; i < listeners.size(); ++i) {
                    IPropertiesDocumentListener listener = (IPropertiesDocumentListener)listeners.get(i);
                    try {
                        listener.beforeUnicodeConvertAtSavingDocument(monitor, document.get(), input);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String uniEscStr = null;
                uniEscStr = PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvert") ? document.get() : (PropertiesEditorPlugin.getDefault().getPreferenceStore().getBoolean("notConvertComment") ? EncodeChanger.unicode2UnicodeEscWithoutComment(document.get()) : EncodeChanger.unicode2UnicodeEsc(document.get()));
                for (int i = 0; i < listeners.size(); ++i) {
                    IPropertiesDocumentListener listener = (IPropertiesDocumentListener)listeners.get(i);
                    try {
                        listener.afterUnicodeConvertAtSavingDocument(monitor, uniEscStr, input);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(uniEscStr.toString().getBytes(encoding));
                IFile file = input.getFile();
                if (file.exists()) {
                    FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                    if (info != null && !overwrite) {
                        this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                    }
                    this.fireElementStateChanging(element);
                    try {
                        file.setContents((InputStream)stream, overwrite, true, monitor);
                    }
                    catch (CoreException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    catch (RuntimeException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    if (info == null) return;
                    ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                    model.updateMarkers(info.fDocument);
                    info.fModificationStamp = this.computeModificationStamp((IResource)file);
                    return;
                }
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.ui", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }
}

