/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import jp.gr.java_conf.ussiy.app.propedit.eclipse.plugin.editors.PropertiesPartitionScanner;
import jp.gr.java_conf.ussiy.app.propedit.util.EncodeChanger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public class PropertiesDocumentProvider
extends FileDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        document.set(EncodeChanger.UnicodeEsc2Unicode(document.get()));
        if (document != null) {
            DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PropertiesPartitionScanner(), new String[]{"__properties_comment"});
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            try {
                String encoding = this.getEncoding(input);
                if (encoding == null) {
                    encoding = this.getDefaultEncoding();
                }
                ByteArrayInputStream stream = new ByteArrayInputStream(EncodeChanger.Unicode2UnicodeEsc(document.get()).getBytes(encoding));
                IFile file = input.getFile();
                if (file.exists()) {
                    FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                    if (info != null && !overwrite) {
                        this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                    }
                    this.fireElementStateChanging(element);
                    try {
                        file.setContents((InputStream)stream, overwrite, true, monitor);
                    }
                    catch (CoreException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    catch (RuntimeException x) {
                        this.fireElementStateChangeFailed(element);
                        throw x;
                    }
                    if (info == null) return;
                    ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                    model.updateMarkers(info.fDocument);
                    info.fModificationStamp = this.computeModificationStamp((IResource)file);
                    return;
                }
                super.doSaveDocument(monitor, element, document, overwrite);
                return;
            }
            catch (IOException x) {
                Status s = new Status(4, "org.eclipse.ui", 0, x.getMessage(), (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }
}

