/*
 * Decompiled with CFR 0.152.
 */
package jp.eclipse.plugin.proptranslator.action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import jp.eclipse.plugin.proptranslator.ExciteTranslator;
import jp.eclipse.plugin.proptranslator.util.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TranslateAction
implements IObjectActionDelegate {
    private IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    String fileFullName = TranslateAction.this.file.getName();
                    String fileFullPath = TranslateAction.this.file.getLocation().toString();
                    String[] fileName = fileFullName.split("\\.");
                    String currentDir = fileFullPath.replace(fileFullName, "");
                    FileInputStream fis = null;
                    InputStreamReader isr = null;
                    BufferedReader br = null;
                    BufferedReader br2 = null;
                    BufferedWriter bw = null;
                    try {
                        try {
                            String line;
                            fis = new FileInputStream(fileFullPath);
                            isr = new InputStreamReader(fis);
                            br = new BufferedReader(isr);
                            int task = 0;
                            while ((line = br.readLine()) != null) {
                                ++task;
                            }
                            ExciteTranslator translator = null;
                            translator = new ExciteTranslator();
                            monitor.beginTask(String.valueOf(fileFullName) + "\u3092 " + translator.getSiteName() + " \u3067\u7ffb\u8a33\u4e2d...", task);
                            fis = new FileInputStream(fileFullPath);
                            isr = new InputStreamReader((InputStream)fis, "ISO-8859-1");
                            br = new BufferedReader(isr);
                            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(currentDir) + fileName[0] + "_en.properties"), "ISO-8859-1"));
                            boolean commentLine = false;
                            while ((line = br.readLine()) != null) {
                                String comment = null;
                                String key = null;
                                String value = null;
                                if ("".equals(line.trim())) {
                                    bw.newLine();
                                    continue;
                                }
                                commentLine = line.trim().startsWith("#");
                                if (commentLine) {
                                    StringBuffer sbComment = new StringBuffer();
                                    StringBuffer sbValue = new StringBuffer();
                                    int i = 0;
                                    while (i < line.length()) {
                                        char c = line.charAt(i);
                                        if (c == '#') {
                                            sbComment.append(c);
                                        } else {
                                            sbValue.append(c);
                                        }
                                        ++i;
                                    }
                                    comment = sbComment.toString();
                                    value = sbValue.toString();
                                } else {
                                    String[] props = line.split("=");
                                    if (props.length != 2) {
                                        bw.newLine();
                                        continue;
                                    }
                                    key = props[0];
                                    value = props[1];
                                }
                                String urlStr = translator.getUrl(value);
                                br2 = new BufferedReader(new InputStreamReader(new URL(urlStr).openStream()));
                                String line2 = null;
                                String translatedValue = null;
                                while ((line2 = br2.readLine()) != null) {
                                    if (!line2.startsWith(translator.getResultTag())) continue;
                                    translatedValue = StringUtils.getTagText(line2);
                                }
                                if (commentLine) {
                                    bw.write(String.valueOf(comment) + translatedValue);
                                } else {
                                    bw.write(String.valueOf(key) + "=" + translatedValue);
                                }
                                bw.newLine();
                                monitor.worked(1);
                            }
                            bw.flush();
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            fis.close();
                            isr.close();
                            br.close();
                            br2.close();
                            bw.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception exception) {}
        MessageDialog.openInformation((Shell)shell, (String)"PropTranslation", (String)"\u7ffb\u8a33\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection ss = (StructuredSelection)selection;
        Object obj = ss.getFirstElement();
        if (obj instanceof IFile) {
            this.file = (IFile)obj;
        }
    }
}

