;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME:   OLED_RES.asm
;;  Version: 1.2, Updated on 2010/4/6 at 11:27:17
;;  Generated by PSoC Designer 
;;
;;  DESCRIPTION: LED user module.
;;
;;
;;  NOTE: User Module APIs conform to the fastcall16 convention for marshalling
;;        arguments and observe the associated "Registers are volatile" policy.
;;        This means it is the caller's responsibility to preserve any values
;;        in the X and A registers that are still needed after the API functions
;;        returns. For Large Memory Model devices it is also the caller's 
;;        responsibility to perserve any value in the CUR_PP, IDX_PP, MVR_PP and 
;;        MVW_PP registers. Even though some of these registers may not be modified
;;        now, there is no guarantee that will remain the case in future releases.
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "OLED_RES.inc"
include "memory.inc"

export _OLED_RES_Start
export  OLED_RES_Start

export _OLED_RES_Stop
export  OLED_RES_Stop

export _OLED_RES_On
export  OLED_RES_On

export _OLED_RES_Off
export  OLED_RES_Off

export _OLED_RES_Switch
export  OLED_RES_Switch

export _OLED_RES_Invert
export  OLED_RES_Invert

export _OLED_RES_GetState
export  OLED_RES_GetState


AREA UserModules (ROM, REL)


.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: OLED_RES_Start(void)
;  FUNCTION NAME: OLED_RES_Stop(void)
;
;  FUNCTION NAME: OLED_RES_Switch(void)
;
;  DESCRIPTION: ( Switch )
;     Turn LED on or off     
;
;  DESCRIPTION: ( Start, Stop )
;     Turn LED off                       
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS:  ( Switch )
;     A => If 0, turn off LED, if > 0 turn on LED
;
;  ARGUMENTS:  ( Start, Stop )
;      None
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
;-----------------------------------------------------------------------------
_OLED_RES_On:
 OLED_RES_On:
   mov  A,0x01
   jmp  OLED_RES_Switch 

_OLED_RES_Start:
 OLED_RES_Start:
_OLED_RES_Stop:
 OLED_RES_Stop:
_OLED_RES_Off:
 OLED_RES_Off:
   mov  A,0x00

_OLED_RES_Switch:
 OLED_RES_Switch:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >Port_2_Data_SHADE

   or   A,0x00                                   ; Check mode
   jz   .Turn_Off_LED

.Turn_On_LED:
IF(0)                                            ; Active High Digit Drive
   or   [Port_2_Data_SHADE],OLED_RES_PinMask
ELSE                                             ; Active Low Digit Drive
   and  [Port_2_Data_SHADE],~OLED_RES_PinMask
ENDIF
   jmp  .Switch_LED

.Turn_Off_LED:
IF(0)                      ; Active High Digit Drive
   and  [Port_2_Data_SHADE],~OLED_RES_PinMask
ELSE                              ; Active Low Digit Drive
   or   [Port_2_Data_SHADE],OLED_RES_PinMask
ENDIF

.Switch_LED:
   mov  A,[Port_2_Data_SHADE]
   mov  reg[OLED_RES_PortDR],A

   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION



.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: OLED_RES_Invert(void)
;
;  DESCRIPTION:
;     Invert state of LED                               
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:  none
;
;  SIDE EFFECTS:
;    REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
;-----------------------------------------------------------------------------
_OLED_RES_Invert:
 OLED_RES_Invert:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >Port_2_Data_SHADE

   xor  [Port_2_Data_SHADE],OLED_RES_PinMask
   mov  A,[Port_2_Data_SHADE]
   mov  reg[OLED_RES_PortDR],A

   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION

.SECTION
;-----------------------------------------------------------------------------
;  FUNCTION NAME: OLED_RES_GetState(void)
;
;  DESCRIPTION:
;     Get state of LED
;
;-----------------------------------------------------------------------------
;
;  ARGUMENTS: none
;
;  RETURNS:  
;    State of LED   1 = ON,  0 = OFF
;
;  SIDE EFFECTS:
;    REGISTERS ARE VOLATILE: THE A AND X REGISTERS MAY BE MODIFIED!
;
;-----------------------------------------------------------------------------
_OLED_RES_GetState:
 OLED_RES_GetState:
   RAM_PROLOGUE RAM_USE_CLASS_4
   RAM_PROLOGUE RAM_USE_CLASS_2
   RAM_SETPAGE_CUR >Port_2_Data_SHADE

   mov   A,[Port_2_Data_SHADE]         ; Get shade value
IF(0)                                  ; Active High Digit Drive
   // Nothing for now
ELSE                                   ; Active Low Digit Drive
   cpl   A                             ; Invert bit if Active low
ENDIF
   and   A,OLED_RES_PinMask            ; Mask off the trash
   jz    .End_LED_GS                   ; If zero, we're done
   mov   A,0x01                        ; Return a 1 no mater what the mask is.

.End_LED_GS:
   RAM_EPILOGUE RAM_USE_CLASS_2
   RAM_EPILOGUE RAM_USE_CLASS_4
   ret
.ENDSECTION
