; Generated by PSoC Designer 
;
INCLUDE "PSoCDynamic.inc"
;==========================================================================
;  PSoCConfig.asm
;  @PSOC_VERSION
;
;  Version: 0.85
;  Revised: June 22, 2004
;  Copyright (c) Cypress Semiconductor 2010. All Rights Reserved.
;
;  This file is generated by the Device Editor on Application Generation.
;  It contains code which loads the configuration data table generated in
;  the file PSoCConfigTBL.asm
;
;  DO NOT EDIT THIS FILE MANUALLY, AS IT IS OVERWRITTEN!!!
;  Edits to this file will not be preserved.
;==========================================================================
;
include "m8c.inc"
include "memory.inc"
include "GlobalParams.inc"

export LoadConfigInit
export _LoadConfigInit
export LoadConfig_no_config
export _LoadConfig_no_config
export UnloadConfig_no_config
export _UnloadConfig_no_config
export ReloadConfig_no_config
export _ReloadConfig_no_config
export LoadConfig_OLED
export _LoadConfig_OLED
export UnloadConfig_OLED
export _UnloadConfig_OLED
export UnloadConfig_Total
export _UnloadConfig_Total
export ACTIVE_CONFIG_STATUS
export BDG_TR_SHADE
export _BDG_TR_SHADE
export Port_1_Data_SHADE
export _Port_1_Data_SHADE
export Port_2_Data_SHADE
export _Port_2_Data_SHADE


export NO_SHADOW
export _NO_SHADOW

FLAG_CFG_MASK:      equ 10h         ;M8C flag register REG address bit mask
END_CONFIG_TABLE:   equ ffh         ;end of config table indicator

AREA psoc_config(rom, rel)

;---------------------------------------------------------------------------
; LoadConfigInit - Establish the start-up configuration (except for a few
;                  parameters handled by boot code, like CPU speed). This
;                  function can be called from user code, but typically it
;                  is only called from boot.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the A and X registers can be modified!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfigInit:
 LoadConfigInit:
    RAM_PROLOGUE RAM_USE_CLASS_4
    RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	mov		[ACTIVE_CONFIG_STATUS], 0

	M8C_SetBank1
	mov		A, reg[BDG_TR]
	mov		[BDG_TR_SHADE], A
	or		[BDG_TR_SHADE], 40h
	M8C_SetBank0
	mov		[Port_1_Data_SHADE], 0h
	mov		[Port_2_Data_SHADE], 0h

	lcall	LoadConfig_no_config
	lcall	LoadConfigTBL_no_config_Ordered


    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration no_config
;
;    Load configuration registers for no_config.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_no_config:
 LoadConfig_no_config:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_no_config_Bank0
    mov     X, <LoadConfigTBL_no_config_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_no_config_Bank1
    mov     X, <LoadConfigTBL_no_config_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+no_config_ADDR_OFF], no_config_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Reload Configuration no_config
;
;    Reload configuration registers for no_config.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_ReloadConfig_no_config:
 ReloadConfig_no_config:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >ReloadConfigTBL_no_config_Bank0
    mov     X, <ReloadConfigTBL_no_config_Bank0
    lcall   LoadConfig              ; Reload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >ReloadConfigTBL_no_config_Bank1
    mov     X, <ReloadConfigTBL_no_config_Bank1
    lcall   LoadConfig              ; Reload the bank 1 values

; set config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	or		[ACTIVE_CONFIG_STATUS+no_config_ADDR_OFF], no_config_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration no_config
;
;    Reset configuration registers for no_config
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_no_config:
 UnloadConfig_no_config:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_no_config_Bank0
    mov     X, <UnloadConfigTBL_no_config_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_no_config_Bank1
    mov     X, <UnloadConfigTBL_no_config_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank1
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+no_config_ADDR_OFF], ~no_config_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Load Configuration OLED
;
;    Load configuration registers for OLED.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_LoadConfig_OLED:
 LoadConfig_OLED:
    RAM_PROLOGUE RAM_USE_CLASS_4
	M8C_SetBank1
; Saving POR level and disabling POR and LVD
	mov		a, reg[VLT_CR]
	push	a
	or		a, 30h
	and		a, f8h
	mov		reg[VLT_CR], a
; writing Port_1_DriveMode_0 register
	and		reg[ 4h], ~80h
	or		reg[ 4h], 80h
; writing Port_1_DriveMode_1 register
	and		reg[ 5h], ~80h
; writing Port_1_DriveMode_2 register
	M8C_SetBank0
	and		reg[ 7h], ~81h
	or		reg[ 7h],  1h
; writing Port_2_DriveMode_0 register
	M8C_SetBank1
	and		reg[ 8h], ~3bh
	or		reg[ 8h], 3bh
; writing Port_2_DriveMode_1 register
	and		reg[ 9h], ~3bh
; writing Port_2_DriveMode_2 register
	M8C_SetBank0
	and		reg[ bh], ~3bh
; writing Port_2_GlobalSelect register
	and		reg[ ah], ~18h
	or		reg[ ah], 18h
; writing AnalogIOControl_0 register
	M8C_SetBank1
	and		reg[62h], ~40h
	or		reg[62h], 40h
; writing AnalogReferenceControl register
	M8C_SetBank0
	and		reg[63h], ~38h
	or		reg[63h], 30h
; writing BDG_TR register
	and		[BDG_TR_SHADE], ~40h
	mov		a, [BDG_TR_SHADE]
	M8C_SetBank1
	mov		reg[eah], a
; writing GlobalDigitalInterconnect_Drive_Odd_Output register
	and		reg[d2h], ~bbh
	or		reg[d2h], bbh
; writing OscillatorControl_3 register
	and		reg[dfh], ~ffh
; writing Row_0_InputMux register
	M8C_SetBank0
	and		reg[b0h], ~c0h
	or		reg[b0h], c0h
; writing Row_1_InputMux register
	and		reg[b8h], ~ fh
	or		reg[b8h],  eh
; writing Row_2_InputMux register
	and		reg[c0h], ~ffh
	or		reg[c0h], bfh
; writing Row_3_InputMux register
	and		reg[c8h], ~ fh
	or		reg[c8h],  bh
; writing Row_3_OutputDrive_0 register
	and		reg[cdh], ~ 2h
	or		reg[cdh],  2h
; writing Row_3_OutputDrive_1 register
	and		reg[ceh], ~10h
	or		reg[ceh], 10h
	M8C_SetBank1
; Restoring POR and LVD level
	pop		a
	mov		reg[VLT_CR], a
	M8C_SetBank0

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Load bank 0 table:
    mov     A, >LoadConfigTBL_OLED_Bank0
    mov     X, <LoadConfigTBL_OLED_Bank0
    lcall   LoadConfig              ; Load the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Load bank 1 table:
    mov     A, >LoadConfigTBL_OLED_Bank1
    mov     X, <LoadConfigTBL_OLED_Bank1
    lcall   LoadConfig              ; Load the bank 1 values

	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
; set config active bit
	or		[ACTIVE_CONFIG_STATUS+OLED_ADDR_OFF], OLED_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration OLED
;
;    Reset configuration registers for OLED
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_OLED:
 UnloadConfig_OLED:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_OLED_Bank0
    mov     X, <UnloadConfigTBL_OLED_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_OLED_Bank1
    mov     X, <UnloadConfigTBL_OLED_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank1
; Saving POR level and disabling POR and LVD
	mov		a, reg[VLT_CR]
	push	a
	or		a, 30h
	and		a, f8h
	mov		reg[VLT_CR], a
; writing AnalogIOControl_0 register
	and		reg[62h], ~40h
; writing AnalogReferenceControl register
	M8C_SetBank0
	and		reg[63h], ~38h
; writing BDG_TR register
	and		[BDG_TR_SHADE], ~40h
	or		[BDG_TR_SHADE], 40h
	mov		a, [BDG_TR_SHADE]
	M8C_SetBank1
	mov		reg[eah], a
; writing GlobalDigitalInterconnect_Drive_Odd_Output register
	and		reg[d2h], ~bbh
; writing OscillatorControl_3 register
	and		reg[dfh], ~ffh
	or		reg[dfh],  2h
; writing Row_0_InputMux register
	M8C_SetBank0
	and		reg[b0h], ~c0h
; writing Row_1_InputMux register
	and		reg[b8h], ~ fh
	or		reg[b8h],  5h
; writing Row_2_InputMux register
	and		reg[c0h], ~ffh
; writing Row_3_InputMux register
	and		reg[c8h], ~ fh
	or		reg[c8h],  5h
; writing Row_3_OutputDrive_0 register
	and		reg[cdh], ~ 2h
; writing Row_3_OutputDrive_1 register
	and		reg[ceh], ~10h
; writing Port_2_GlobalSelect register
	and		reg[ ah], ~18h
; writing Port_2_DriveMode_2 register
	and		reg[ bh], ~3bh
	or		reg[ bh], 3bh
; writing Port_2_DriveMode_1 register
	M8C_SetBank1
	and		reg[ 9h], ~3bh
	or		reg[ 9h], 3bh
; writing Port_2_DriveMode_0 register
	and		reg[ 8h], ~3bh
; writing Port_1_DriveMode_2 register
	M8C_SetBank0
	and		reg[ 7h], ~81h
	or		reg[ 7h], 80h
; writing Port_1_DriveMode_1 register
	M8C_SetBank1
	and		reg[ 5h], ~80h
	or		reg[ 5h], 80h
; writing Port_1_DriveMode_0 register
	and		reg[ 4h], ~80h
	M8C_SetBank0
	M8C_SetBank1
; Restoring POR and LVD level
	pop		a
	mov		reg[VLT_CR], a
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	and		[ACTIVE_CONFIG_STATUS+OLED_ADDR_OFF], ~OLED_BIT
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret

;---------------------------------------------------------------------------
; Unload Configuration Total
;
;    Reset configuration registers for Total
;    to their values as initially configured.
;    IO Bank 0 registers a loaded first,then those in IO Bank 1.
;
;       INPUTS: None.
;      RETURNS: Nothing.
; SIDE EFFECTS: Registers are volatile: the CPU A and X registers may be
;               modified as may the Page Pointer registers!
;               In the large memory model currently only the page
;               pointer registers listed below are modified.  This does
;               not guarantee that in future implementations of this
;               function other page pointer registers will not be
;               modified.
;          
;               Page Pointer Registers Modified: 
;               CUR_PP
;
_UnloadConfig_Total:
 UnloadConfig_Total:
    RAM_PROLOGUE RAM_USE_CLASS_4

	push	x
    M8C_SetBank0                    ; Force bank 0
    mov     a, 0                    ; Specify bank 0
    asr     a                       ; Store in carry flag
                                    ; Bank 0 table address:
    mov     A, >UnloadConfigTBL_Total_Bank0
    mov     X, <UnloadConfigTBL_Total_Bank0
    lcall   LoadConfig              ; Unload the bank 0 values

    mov     a, 1                    ; Specify bank 1
    asr     a                       ; Store in carry flag
                                    ; Bank 1 table address:
    mov     A, >UnloadConfigTBL_Total_Bank1
    mov     X, <UnloadConfigTBL_Total_Bank1
    lcall   LoadConfig              ; Unload the bank 1 values

	M8C_SetBank1
	M8C_SetBank0
; clear config active bit
	RAM_SETPAGE_CUR >ACTIVE_CONFIG_STATUS
	mov		[ACTIVE_CONFIG_STATUS+0], 0
    M8C_SetBank0                    ; Force return to bank 0
	pop		x

    RAM_EPILOGUE RAM_USE_CLASS_4
    ret




;---------------------------------------------------------------------------
; LoadConfig - Set IO registers as specified in ROM table of (address,value)
;              pairs. Terminate on address=0xFF.
;
;  INPUTS:  [A,X] points to the table to be loaded
;           Flag Register Carry bit encodes the Register Bank
;           (Carry=0 => Bank 0; Carry=1 => Bank 1)
;
;  RETURNS: nothing.
;
;  STACK FRAME:  X-4 I/O Bank 0/1 indicator
;                X-3 Temporary store for register address
;                X-2 LSB of config table address
;                X-1 MSB of config table address
;
LoadConfig:
    RAM_PROLOGUE RAM_USE_CLASS_2
    add     SP, 2                   ; Set up local vars
    push    X                       ; Save config table address on stack
    push    A
    mov     X, SP
    mov     [X-4], 0                ; Set default Destination to Bank 0
    jnc     .BankSelectSaved        ; Carry says Bank 0 is OK
    mov     [X-4], 1                ; No Carry: default to Bank 1
.BankSelectSaved:
    pop     A
    pop     X

LoadConfigLp:
    M8C_SetBank0                    ; Switch to bank 0
    M8C_ClearWDT                    ; Clear the watchdog for long inits
    push    X                       ; Preserve the config table address
    push    A
    romx                            ; Load register address from table
    cmp     A, END_CONFIG_TABLE     ; End of table?
    jz      EndLoadConfig           ;   Yes, go wrap it up
    mov     X, SP                   ;
    tst     [X-4], 1                ; Loading IO Bank 1?
    jz      .IOBankNowSet           ;    No, Bank 0 is fine
    M8C_SetBank1                    ;   Yes, switch to Bank 1
.IOBankNowSet:
    mov     [X-3], A                ; Stash the register address
    pop     A                       ; Retrieve the table address
    pop     X
    inc     X                       ; Advance to the data byte
    adc     A, 0
    push    X                       ; Save the config table address again
    push    A
    romx                            ; load config data from the table
    mov     X, SP                   ; retrieve the register address
    mov     X, [X-3]
    mov     reg[X], A               ; Configure the register
    pop     A                       ; retrieve the table address
    pop     X
    inc     X                       ; advance to next table entry
    adc     A, 0
    jmp     LoadConfigLp            ; loop to configure another register
EndLoadConfig:
    add     SP, -4
    RAM_EPILOGUE RAM_USE_CLASS_2
    ret

AREA InterruptRAM(ram, rel)

NO_SHADOW:
_NO_SHADOW:
; active configuration status byte
ACTIVE_CONFIG_STATUS:	BLK	1

; write only register shadows
_Port_1_Data_SHADE:
Port_1_Data_SHADE:	BLK	1
_Port_2_Data_SHADE:
Port_2_Data_SHADE:	BLK	1
_BDG_TR_SHADE:
BDG_TR_SHADE:	BLK	1

AREA text(rom, rel)
