#include <m8c.h>        // part specific constants and macros
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules

#include "main.h"
#include "oled_portconfig.h"
#include "small_font.h"

unsigned char X_Witch; //character's width
unsigned char Y_Witch; //character's height
unsigned char Font_Wrod; //how many byte this character's
//unsigned char __f lash *Char_TAB; //word stock's pointer
unsigned int Char_Color; //character's color

//============================OLED_Driver================
// Illustration: driver
// Function:: writer oled command register,intinial oled driver IC etc.
// Parameter: Command
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//===============write oled command register====================
void OLED_RegWrite(unsigned char Command)
{
	OLED_CS_Off();
	OLED_DC_Off();
	OLED_CS_On();

	SPIM_OLED_SendTxData(Command);
	while(!(SPIM_OLED_bReadStatus() & SPIM_OLED_SPIM_TX_BUFFER_EMPTY));
	
	OLED_CS_Off();
}
//=============================OLED_Driver===============
// Illustration: driver
// Function: writer oled data register,intinial oled driver IC etc.
// Parameter: Data
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//================write oled data register=======================
void OLED_DataWrite(unsigned char Data)
{
	OLED_CS_Off();
	OLED_DC_On();
	OLED_CS_On();

	SPIM_OLED_SendTxData(Data);
	while(!(SPIM_OLED_bReadStatus() & SPIM_OLED_SPIM_TX_BUFFER_EMPTY));

	OLED_CS_Off();
}
//=============power function=================================
// Illustration: Function
// Function: writer a point in oled,point color can select yourself
// Parameter: Dat
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//==============wr ite oled register=============================
void OLED_DataWrite_to(unsigned int Dat)
{
	OLED_DataWrite((unsigned char)((Dat >> 8)& 0x00ff));
	OLED_DataWrite((unsigned char)(Dat & 0x00ff));
}
//=============power function=================================
// Illustration: Function
// Function: MCU port initial,like port direction,pull-up resistor,input or output etc.
// Parameter: Non
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//=========================================================
void PortInit(void)
{
	OLED_CS_Start();
	OLED_DC_Start();
	OLED_RES_Start();
	SPIM_OLED_Start(SPIM_OLED_SPIM_MODE_0 | SPIM_OLED_SPIM_MSB_FIRST);

}
//=============power function=================================
// Illustration: Function
// Function: Delay function
// Parameter: Time
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//=========================================================
void TimeDelay(int Time)
{
	int i;
	while(Time > 0)
	{
		for(i = 0;i < 800;i++)
		{
			asm("nop");
		}
		Time --;
	}
}

void OLED_Init(void)
{
	PortInit();
	OLED_RES_On();
	TimeDelay(80);
	OLED_RES_Off();
	TimeDelay(20);
	OLED_RegWrite(0xae);	//OLED display OFF

	//Row Address
	OLED_RegWrite(0x75);	/* Set Row Address */
	OLED_RegWrite(0x00);	/* Start = 0 */
	OLED_RegWrite(0x3f);	/* End = 63 */
	OLED_RegWrite(0x15);	/* Set Column Address */
	OLED_RegWrite(0x00);	/* Start = 0 */
	OLED_RegWrite(0x5F);	/* End = 96 */
	
	//Contrast
	OLED_RegWrite(0xa0);	//Set remap & data format 0111 0000
	OLED_RegWrite(0x74);
	OLED_RegWrite(0xa1);	//set display star row RAM
	OLED_RegWrite(0x00);
	OLED_RegWrite(0xa2);	//set dispaly offset
	OLED_RegWrite(0x00);
	OLED_RegWrite(0xa4);	//Set Display Mode
	OLED_RegWrite(0xa8);	//Set Multiplex Ratio
	OLED_RegWrite(0x3f);
	OLED_RegWrite(0xad);	//Set Master Configuration
	OLED_RegWrite(0x8f);	//(External VCC Supply Selected)
	OLED_RegWrite(0xB0);	//Set Power Saving Mode
	OLED_RegWrite(0x1a);
	OLED_RegWrite(0xB1);	//Set Phase 1 & 2 Period Adjustment
	OLED_RegWrite(0x74);
	OLED_RegWrite(0xb3); 	//Set Display Clock Divide Ratio / Oscillator Frequency
	OLED_RegWrite(0xd0);
	OLED_RegWrite(0x8A);	//Set Second Pre-charge Speed of Color A
	OLED_RegWrite(0x81);
	OLED_RegWrite(0x8B);	//Set Second Pre-charge Speed of Color B
	OLED_RegWrite(0x82);
	OLED_RegWrite(0x8C);	//Set Second Pre-charge Speed of Color C
	OLED_RegWrite(0x83);
	OLED_RegWrite(0xBB);	//Set Pre-charge Level
	OLED_RegWrite(0x3e);
	OLED_RegWrite(0xBE);	//Set VCOMH
	OLED_RegWrite(0x3e);
	OLED_RegWrite(0x87);	//Set Master Current Control
	OLED_RegWrite(0x0f );
	OLED_RegWrite(0x81);	//Set Contrast Control for Color “A”
	OLED_RegWrite(0x80);
	OLED_RegWrite(0x82);	//Set Contrast Control for Color “B”
	OLED_RegWrite(0x80);
	OLED_RegWrite(0x83);	//Set Contrast Control for Color “C”
	OLED_RegWrite(0x80);
	OLED_RegWrite(0xaf);	//display ON
}
//=============power function=================================
// Illustration: Function
// Function: Fill all oled screen,all of color,e.g.:Dot=0x0000h,black screen
// Dot=0x0018h,red screen
// Parameter: Dot
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port configer
// More: Can refer e.g.
//=========================================================
void Full_OLED_Screen(unsigned int Dot)
{
	unsigned char i,j;
	for(i=0;i<64;i++)
	{
		for(j=0;j<96;j++)
		{
			//Draw_Dot(j,i,Dot);
			OLED_DataWrite_to(Dot);
		}
	}
}
//=============power function=================================
// Illustration: Function
// Function: Write a dot in screen
// Parameter: x,y,Color
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//=========================================================
void Draw_Dot(unsigned char x,unsigned char y,unsigned int Color)
{
	OLED_RegWrite(0x15);
	OLED_RegWrite(x);
	OLED_RegWrite(x);
	OLED_RegWrite(0x75);
	OLED_RegWrite(y);
	OLED_RegWrite(y);
	OLED_DataWrite_to(Color);
	OLED_DataWrite_to(Color);
}
void ChangeFontColor(unsigned int color)
{
	Char_Color = color;
}

//=============power function=================================
// Illustration: Function
// Function: Input a normal character
// Parameter: X:X coordinate,Y:Y coordinate,a:display a character from word stock's offset
// Return: Non
// Reference: Other book or IC DataSheet
// Note: Base your MCU and port conf iger
// More: Can refer e.g.
//=========================================================
void PutChar(unsigned char x,unsigned char y,unsigned char a)
{
	int i,j;
	// unsigned char __f lash *p_data;
	unsigned char Temp=0;
	unsigned char Index=0;
	
	X_Witch = 5;
	Y_Witch = 8;
	//Char_Color = 0xffff;

	j = 0;
	i = 0;
	if(a < 32)a=32;
	for(i=0; i<X_Witch; i++)
	{	
		Temp = FontLookup[a-32][i];
		for(j=Y_Witch;j!=0;j--){
			if((Temp & 0x80)==0x80){
				Draw_Dot(x+i,y+j,Char_Color);
			}else{
				Draw_Dot(x+i,y+j,0);
			}
		Temp = Temp << 1;
		}
	}
	

}


