// psychlops_platform_selector.h

#if defined(__APPLE__)
#define PSYCHLOPS_PLATFORM_OSX
#elif defined(LINUX)
#else
#ifndef PSYCHLOPS_PLATFORM_WIN32GL
#define PSYCHLOPS_PLATFORM_WIN32GL
#endif
#ifdef PSYCHLOPS_PLATFORM_WIN32GL
#define PSYCHLOPS_PLATFORM_WIN32
#endif
#endif


#ifdef PSYCHLOPS_PLATFORM_WIN32

#ifdef PSYCHLOPS_MAIN_API_PLATFORM
#include "win32/psychlops_app_main_Win32.h"
#endif

#ifdef PSYCHLOPS_HID_API_PLATFORM
#include "win32/psychlops_io_API_Win32.h"
#endif

#ifdef PSYCHLOPS_APPSTATE_API_PLATFORM
#include "win32/psychlops_app_state_Win32.h"
#endif

#ifdef PSYCHLOPS_CLOCK_API_PLATFORM
#include "win32/psychlops_io_clock_Win32.h"
#endif

#endif

#ifdef PSYCHLOPS_PLATFORM_WIN32GL

#ifdef PSYCHLOPS_WINDOW_API_PLATFORM
#include "win32gl/psychlops_g_API_win32gl.h"
#endif

#ifdef PSYCHLOPS_SHADER_PLATFORM
#define GLEW_STATIC
#include "win32gl/extension/glew/glew.h"
#include "win32gl/psychlops_g_API_win32gl.h"
#undef GLEW_STATIC
#endif

#endif




#ifdef PSYCHLOPS_PLATFORM_OSX

#ifdef PSYCHLOPS_MAIN_API_PLATFORM
#include "osx/psychlops_app_main_osx.h"
#endif

#ifdef PSYCHLOPS_APPSTATE_API_PLATFORM
#include "osx/psychlops_app_state_OSX.h"
#endif

#ifdef PSYCHLOPS_HID_API_PLATFORM
#include "osx/psychlops_io_API_OSX.h"
#endif

#ifdef PSYCHLOPS_CLOCK_API_PLATFORM
#include "osx/psychlops_io_clock_OSX.h"
#endif

#ifdef PSYCHLOPS_WINDOW_API_PLATFORM
#include "osx/psychlops_g_API_OSX.h"
#endif

#ifdef PSYCHLOPS_SHADER_PLATFORM
#if !defined(PANTHER)
#include <OpenGL/gl.h>
#else
#define GLEW_STATIC
#include "win32gl/extension/glew/glew.h"
#undef GLEW_STATIC
#endif
#include "osx/psychlops_g_API_OSX.h"
#endif

#endif
