/*
 *  system.h
 */

#ifndef __SYSTEM_H__
#define __SYSTEM_H__

#include <IOKit/IOLib.h>

#define __iomem
#define __devinit
#define __devinitdata
#define __devexit
#define __user
#define __exit
#define __init

#define mutex_init mutex_init_dmy
#define mutex_lock mutex_lock_dmy
#define mutex_unlock mutex_unlock_dmy
#define kfree kfree_dmy

#define EIO         1
#define EINVAL      2
#define ENOMEM      3
#define ESPIPE      4

#define printk IOLog
#define KERN_ERR
#define KERN_INFO
#define MODULE_AUTHOR(p1)
#define MODULE_DESCRIPTION(p1)
#define MODULE_LICENSE(p1)
#define MODULE_PARM_DESC(p1,p2)
#define MODULE_DEVICE_TABLE(p1,p2)

#define _IOW(type,nr,size) (nr)
#define _IO(type,nr) (nr)
#define _IOR(type,nr,size) (nr)

#define module_param(p1,p2,p3)
#define module_init(p1)
#define module_exit(p1)

#define pci_resource_start(p1, p2) (p2)
#define pci_resource_len(p1, p2) (p2)
#define kthread_run(p1,p2,p3,...) (0)
#define __devexit_p(x) x

#define MINORBITS       20
#define MINORMASK       ((1U << MINORBITS) - 1)
#define MAJOR(dev)      ((unsigned int) ((dev) >> MINORBITS))
#define MINOR(dev)      ((unsigned int) ((dev) & MINORMASK))
#define MKDEV(ma,mi)    (((ma) << MINORBITS) | (mi))

#define LINUX_VERSION_CODE 11
#define KERNEL_VERSION(p1,p2,p3) p3

#define PCI_ANY_ID (~0)
#define THIS_MODULE NULL

#define DMA_BIT_MASK(n) (((n) == 64) ? ~0ULL : ((1ULL<<(n))-1))
#define DMA_32BIT_MASK  DMA_BIT_MASK(32)
#define GFP_KERNEL 123

#define MAX_ERRNO       4095
#define unlikely(x)     __builtin_expect(!!(x), 0)
#define IS_ERR_VALUE(x) unlikely((x) >= (unsigned long)-MAX_ERRNO)
static inline void *ERR_PTR(long error)
{
    return (void *) error;
}
static inline long PTR_ERR(const void *ptr)
{
    return (long) ptr;
}
static inline long IS_ERR(const void *ptr)
{
    return IS_ERR_VALUE((unsigned long)ptr);
}

#define PCI_VENDOR_ID           0x00    /* 16 bits */
#define PCI_DEVICE_ID           0x02    /* 16 bits */
#define PCI_COMMAND             0x04    /* 16 bits */
#define  PCI_COMMAND_IO         0x1     /* Enable response in I/O space */
#define  PCI_COMMAND_MEMORY     0x2     /* Enable response in Memory space */
#define  PCI_COMMAND_MASTER     0x4     /* Enable bus mastering */
#define  PCI_COMMAND_SPECIAL    0x8     /* Enable response to special cycles */
#define  PCI_COMMAND_INVALIDATE 0x10    /* Use memory write and invalidate */
#define  PCI_COMMAND_VGA_PALETTE 0x20   /* Enable palette snooping */
#define  PCI_COMMAND_PARITY     0x40    /* Enable parity checking */
#define  PCI_COMMAND_WAIT       0x80    /* Enable address/data stepping */
#define  PCI_COMMAND_SERR       0x100   /* Enable SERR */
#define  PCI_COMMAND_FAST_BACK  0x200   /* Enable back-to-back writes */
#define  PCI_COMMAND_INTX_DISABLE 0x400 /* INTx Emulation Disable */


typedef UInt8 __u8;
typedef UInt16 __u16;
typedef UInt32 __u32;
typedef UInt32 kernel_ulong_t;
typedef UInt64 dma_addr_t;
typedef UInt16 u16;
typedef UInt32 u32;
typedef UInt64 u64;
typedef long long loff_t;
typedef unsigned gfp_t;
typedef u32 resource_size_t;

struct mutex {
};

struct kobject {
};

struct module {
};

struct __wait_queue_head {
};

struct inode {
};

struct file {
    void *private_data;
};

struct file_struct {
};

struct file_lock {
};

struct pipe_inode_info {
};

struct page {
};

struct kiocb {
};

struct dentry {
};

struct vm_area_struct {
};

struct poll_table_struct {
};

struct iovec {
};

typedef int (*filldir_t)(void *, const char *, int, loff_t, u64, unsigned);
typedef struct files_struct *fl_owner_t;

struct file_operations {
    struct module *owner;
    loff_t (*llseek) (struct file *, loff_t, int);
    ssize_t (*read) (struct file *, char __user *, size_t, loff_t *);
    ssize_t (*write) (struct file *, const char __user *, size_t, loff_t *);
    ssize_t (*aio_read) (struct kiocb *, const struct iovec *, unsigned long, loff_t);
    ssize_t (*aio_write) (struct kiocb *, const struct iovec *, unsigned long, loff_t);
    int (*readdir) (struct file *, void *, filldir_t);
    unsigned int (*poll) (struct file *, struct poll_table_struct *);
    int (*ioctl) (struct inode *, struct file *, unsigned int, unsigned long);
    long (*unlocked_ioctl) (struct file *, unsigned int, unsigned long);
    long (*compat_ioctl) (struct file *, unsigned int, unsigned long);
    int (*mmap) (struct file *, struct vm_area_struct *);
    int (*open) (struct inode *, struct file *);
    int (*flush) (struct file *, fl_owner_t id);
    int (*release) (struct inode *, struct file *);
    int (*fsync) (struct file *, struct dentry *, int datasync);
    int (*aio_fsync) (struct kiocb *, int datasync);
    int (*fasync) (int, struct file *, int);
    int (*lock) (struct file *, int, struct file_lock *);
    ssize_t (*sendpage) (struct file *, struct page *, int, size_t, loff_t *, int);
    unsigned long (*get_unmapped_area)(struct file *, unsigned long, unsigned long, unsigned long, unsigned long);
    int (*check_flags)(int);
    int (*dir_notify)(struct file *filp, unsigned long arg);
    int (*flock) (struct file *, int, struct file_lock *);
    ssize_t (*splice_write)(struct pipe_inode_info *, struct file *, loff_t *, size_t, unsigned int);
    ssize_t (*splice_read)(struct file *, loff_t *, struct pipe_inode_info *, size_t, unsigned int);
    int (*setlease)(struct file *, long, struct file_lock **);
};

struct list_head {
};

struct pci_device_id {
    __u32 vendor, device;       /* Vendor and device ID or PCI_ANY_ID*/
    __u32 subvendor, subdevice; /* Subsystem ID's or PCI_ANY_ID */
    __u32 class, class_mask;    /* (class,subclass,prog-if) triplet */
    kernel_ulong_t driver_data; /* Data private to the driver */
};

struct pm_ext_ops {
};

struct pci_error_handlers {
};

struct device_driver {
};

struct pci_dynids {
};

typedef struct pm_message {
    int event;
} pm_message_t;

struct pci_dev {
};

struct pci_driver {
    struct list_head node;
    char *name;
    const struct pci_device_id *id_table;   /* must be non-NULL for probe to be called */
    int  (*probe)  (struct pci_dev *dev, const struct pci_device_id *id);   /* New device inserted */
    void (*remove) (struct pci_dev *dev);   /* Device removed (NULL if not a hot-plug capable driver) */
    int  (*suspend) (struct pci_dev *dev, pm_message_t state);      /* Device suspended */
    int  (*suspend_late) (struct pci_dev *dev, pm_message_t state);
    int  (*resume_early) (struct pci_dev *dev);
    int  (*resume) (struct pci_dev *dev);                   /* Device woken up */
    void (*shutdown) (struct pci_dev *dev);
    struct pm_ext_ops *pm;
    struct pci_error_handlers *err_handler;
    struct device_driver    driver;
    struct pci_dynids dynids;
};




struct cdev {
    struct kobject kobj;
    struct module *owner;
    const struct file_operations *ops;
    struct list_head list;
    dev_t dev;
    unsigned int count;
};


struct class {
};

struct task_struct {
};

typedef struct __wait_queue_head wait_queue_head_t;

extern void mutex_init(struct mutex *);
extern void mutex_lock(struct mutex *);
extern void mutex_unlock(struct mutex *);

extern void writel(__u32, void __iomem *);
extern __u32 readl(void __iomem *);
extern void schedule_timeout_interruptible(__u32);
extern __u32 msecs_to_jiffies(__u32);
extern int kthread_stop(struct task_struct *k);
extern int kthread_should_stop(void);
extern int iminor(struct inode *);

extern void wake_up(wait_queue_head_t *);
extern void wait_event_timeout(wait_queue_head_t, bool condition, __u32);
extern unsigned long copy_to_user(void __user *to, const void *from, unsigned long n);
extern unsigned long copy_from_user(void *to, const void __user *from, unsigned long n);
extern loff_t no_llseek(struct file *file, loff_t offset, int origin);
/*
{
    return -ESPIPE;
}
*/
extern void *pci_alloc_consistent(struct pci_dev *pdev, size_t len, dma_addr_t *pba);
extern void pci_free_consistent(struct pci_dev *pdev, size_t n, void *p, dma_addr_t ba);
extern int pci_set_dma_mask(struct pci_dev *dev, u64 mask);
extern int pci_enable_device(struct pci_dev *dev);
extern int pci_read_config_word(struct pci_dev *dev, int where, u16 *val);
extern void pci_set_master(struct pci_dev *dev);
extern void *pci_get_drvdata(struct pci_dev *pdev);
extern void pci_set_drvdata(struct pci_dev *pdev, void *data);
extern int pci_register_driver(struct pci_driver *);
extern void pci_unregister_driver(struct pci_driver *dev);

extern void *kzalloc(size_t size, gfp_t flags);
extern void kfree(const void *ptr);

extern int request_mem_region(resource_size_t start, resource_size_t n, const char *name);
extern void release_mem_region(resource_size_t, resource_size_t);
extern void __iomem *ioremap(unsigned long offset, unsigned long size);
extern void iounmap(volatile void __iomem *addr);
extern int alloc_chrdev_region(dev_t *, unsigned, unsigned, const char *);
extern void init_waitqueue_head(wait_queue_head_t *q);
extern void cdev_init(struct cdev *, const struct file_operations *);
extern int cdev_add(struct cdev *, dev_t, unsigned);
extern void cdev_del(struct cdev *);
extern struct device *device_create(struct class *class, struct device *parent, dev_t devt, void *drvdata, const char *fmt, ...);
extern void device_destroy(struct class *cls, dev_t devt);
extern void unregister_chrdev_region(dev_t, unsigned);
extern struct class *class_create(struct module *owner, const char *name);
extern void class_destroy(struct class *cls);


#endif