<?php
// リストデータ汎用処理クラス
class PUBLOGXMLListData extends PublogXMLData
{
/*
	$list_data = array(
		'id' => null,
		'title' => null,
		'tagline' => null,
		'issued' => null,
		'modified' => null
	);
*/

var $list_conf = array(
			'rt' => null,	// root tag name
			'lt' => null		// list tag name
		);
var $list_counter;

// コンストラクタ ----------------------------------
	function PUBLOGXMLListData($conf = null,$list_conf = null)
	{
		$this->set_conf($conf);
		$this->set_list_conf($list_conf);
//		$this->load();
	}
// 設定 ----------------------------------
	function set_list_conf($list_conf=null)
	{
		if(is_array($list_conf))
		{
			$this->list_conf = array_merge($this->list_conf,$list_conf);
		}else{
			return false;
		}
		return true;
	}

	function list_count()
	{
		$list =& $this->pxml->get_array('/'.$this->list_conf['rt'].'/'.$this->list_conf['lt']);
		if($list===true)
		{
			$this->list_counter = count($list);
		}else{
			$this->list_counter = 0;
		}
		return $this->list_counter;
	}
	function load()
	{
		$ret = parent::load();
		if($ret){
			$this->list_count();
		}
		return $ret;
	}
	function _save($mode="add")
	{
		$this->pxml->node_data[$this->list_conf['rt']]['count'] = $this->list_counter;
		return parent::_save($mode);
	}
// データ操作 ----------------------------------
	// スレッドデータ取得(id 指定がなければリスト全体のデータ)
	function &get($id = null)
	{
		if(empty($id))
		{
			return $this->pxml->node_data;
		}
		// id 存在チェック
		if(!array_key_exists($this->list_conf['lt'].'__'.$id,
			$this->pxml->node_data[$this->list_conf['rt']]))
		{
			return false;
		}
		return $this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$id];
	}
	// 新規スレッドデータ追加
	function add($listdata = null)
	{
		if(empty($listdata))
		{
			return false;
		}
		// id 重複チェック
		if(array_key_exists($this->list_conf['lt'].'__'.$listdata['id'],
			$this->pxml->node_data[$this->list_conf['rt']]))
		{
			return false;
		}
		// スレッドデータ追加
		$this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$listdata['id']] =& $listdata;
		$this->list_counter++;
		return true;
	}
	function remove($id = null)
	{
		if(empty($id))
		{
			return false;
		}
		// id 存在チェック
		if(!array_key_exists($this->list_conf['lt'].'__'.$id,
			$this->pxml->node_data[$this->list_conf['rt']]))
		{
			return false;
		}
		// スレッドデータ削除
		$keep = $this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$id];
		$this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$id] = null;
		unset($this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$id]);
		return $keep;
	}
	function &update($thread_data = null)
	{
		// スレッドリストデータの修正
		if(empty($thread_data))
		{
			return false;
		}
		// id 存在チェック
		if(!array_key_exists($this->list_conf['lt'].'__'.$thread_data['id'],
			$this->pxml->node_data[$this->list_conf['rt']]))
		{
			return false;
		}
		// スレッドデータ上書き
//		$this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$thread_data['id']] =& $thread_data;
		$this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$thread_data['id']]
		 =& array_merge(
		 $this->pxml->node_data[$this->list_conf['rt']][$this->list_conf['lt'].'__'.$thread_data['id']],
		 $thread_data);
		return $this->pxml->node_data;
	}
}

?>
